/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.processor;

import io.ray.streaming.operator.OneInputOperator;
import io.ray.streaming.operator.OperatorType;
import io.ray.streaming.operator.SourceOperator;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.operator.TwoInputOperator;
import io.ray.streaming.runtime.core.processor.OneInputProcessor;
import io.ray.streaming.runtime.core.processor.SourceProcessor;
import io.ray.streaming.runtime.core.processor.StreamProcessor;
import io.ray.streaming.runtime.core.processor.TwoInputProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessBuilder.class);

    public static StreamProcessor buildProcessor(StreamOperator streamOperator) {
        OperatorType type = streamOperator.getOpType();
        LOGGER.info("Building StreamProcessor, operator type = {}, operator = {}.", (Object)type, (Object)streamOperator.getClass().getSimpleName());
        switch (type) {
            case SOURCE: {
                return new SourceProcessor((SourceOperator)streamOperator);
            }
            case ONE_INPUT: {
                return new OneInputProcessor((OneInputOperator)streamOperator);
            }
            case TWO_INPUT: {
                return new TwoInputProcessor((TwoInputOperator)streamOperator);
            }
        }
        throw new RuntimeException("current operator type is not support");
    }
}

