/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import java.io.Serializable;

public class ExecutionEdge
implements Serializable {
    private final ExecutionVertex sourceExecutionVertex;
    private final ExecutionVertex targetExecutionVertex;
    private final Partition partition;
    private final String executionEdgeIndex;

    public ExecutionEdge(ExecutionVertex sourceExecutionVertex, ExecutionVertex targetExecutionVertex, ExecutionJobEdge executionJobEdge) {
        this.sourceExecutionVertex = sourceExecutionVertex;
        this.targetExecutionVertex = targetExecutionVertex;
        this.partition = executionJobEdge.getPartition();
        this.executionEdgeIndex = this.generateExecutionEdgeIndex();
    }

    private String generateExecutionEdgeIndex() {
        return this.sourceExecutionVertex.getExecutionVertexId() + "\u2014" + this.targetExecutionVertex.getExecutionVertexId();
    }

    public ExecutionVertex getSourceExecutionVertex() {
        return this.sourceExecutionVertex;
    }

    public ExecutionVertex getTargetExecutionVertex() {
        return this.targetExecutionVertex;
    }

    public String getTargetExecutionJobVertexName() {
        return this.getTargetExecutionVertex().getExecutionJobVertexName();
    }

    public int getSourceVertexId() {
        return this.sourceExecutionVertex.getExecutionVertexId();
    }

    public int getTargetVertexId() {
        return this.targetExecutionVertex.getExecutionVertexId();
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getExecutionEdgeIndex() {
        return this.executionEdgeIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.sourceExecutionVertex).add("target", (Object)this.targetExecutionVertex).add("partition", (Object)this.partition).add("index", (Object)this.executionEdgeIndex).toString();
    }
}

