/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.context.impl;

import io.ray.streaming.runtime.config.global.ContextBackendConfig;
import io.ray.streaming.runtime.context.ContextBackend;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class LocalFileContextBackend
implements ContextBackend {
    private final String rootPath;

    public LocalFileContextBackend(ContextBackendConfig config) {
        this.rootPath = config.fileStateRootPath();
    }

    @Override
    public boolean exists(String key) {
        File file = new File(this.rootPath, key);
        return file.exists();
    }

    @Override
    public byte[] get(String key) throws Exception {
        File file = new File(this.rootPath, key);
        if (file.exists()) {
            return FileUtils.readFileToByteArray((File)file);
        }
        return null;
    }

    @Override
    public void put(String key, byte[] value) throws Exception {
        File file = new File(this.rootPath, key);
        FileUtils.writeByteArrayToFile((File)file, (byte[])value);
    }

    @Override
    public void remove(String key) {
        File file = new File(this.rootPath, key);
        FileUtils.deleteQuietly((File)file);
    }

    protected void rename(String fromKey, String toKey) throws Exception {
        File srcFile = new File(this.rootPath, fromKey);
        File dstFile = new File(this.rootPath, toKey);
        FileUtils.moveFile((File)srcFile, (File)dstFile);
    }
}

