/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.worker.context;

import com.google.common.base.Preconditions;
import io.ray.streaming.api.context.RuntimeContext;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import io.ray.streaming.state.backend.AbstractKeyStateBackend;
import io.ray.streaming.state.backend.KeyStateBackend;
import io.ray.streaming.state.backend.OperatorStateBackend;
import io.ray.streaming.state.keystate.desc.AbstractStateDescriptor;
import io.ray.streaming.state.keystate.desc.ListStateDescriptor;
import io.ray.streaming.state.keystate.desc.MapStateDescriptor;
import io.ray.streaming.state.keystate.desc.ValueStateDescriptor;
import io.ray.streaming.state.keystate.state.ListState;
import io.ray.streaming.state.keystate.state.MapState;
import io.ray.streaming.state.keystate.state.ValueState;
import java.util.Map;

public class StreamingRuntimeContext
implements RuntimeContext {
    protected transient KeyStateBackend keyStateBackend;
    protected transient OperatorStateBackend operatorStateBackend;
    private int taskId;
    private int taskIndex;
    private int parallelism;
    private Long checkpointId;
    private Map<String, String> config;

    public StreamingRuntimeContext(ExecutionVertex executionVertex, Map<String, String> config, int parallelism) {
        this.taskId = executionVertex.getExecutionVertexId();
        this.config = config;
        this.taskIndex = executionVertex.getExecutionVertexIndex();
        this.parallelism = parallelism;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Map<String, String> getJobConfig() {
        return this.config;
    }

    public Long getCheckpointId() {
        return this.checkpointId;
    }

    public void setCheckpointId(long checkpointId) {
        if (this.keyStateBackend != null) {
            this.keyStateBackend.setCheckpointId(checkpointId);
        }
        if (this.operatorStateBackend != null) {
            this.operatorStateBackend.setCheckpointId(checkpointId);
        }
        this.checkpointId = checkpointId;
    }

    public void setCurrentKey(Object key) {
        this.keyStateBackend.setCurrentKey(key);
    }

    public KeyStateBackend getKeyStateBackend() {
        return this.keyStateBackend;
    }

    public void setKeyStateBackend(KeyStateBackend keyStateBackend) {
        this.keyStateBackend = keyStateBackend;
    }

    public <T> ValueState<T> getValueState(ValueStateDescriptor<T> stateDescriptor) {
        this.stateSanityCheck((AbstractStateDescriptor)stateDescriptor, (AbstractKeyStateBackend)this.keyStateBackend);
        return this.keyStateBackend.getValueState(stateDescriptor);
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateDescriptor) {
        this.stateSanityCheck((AbstractStateDescriptor)stateDescriptor, (AbstractKeyStateBackend)this.keyStateBackend);
        return this.keyStateBackend.getListState(stateDescriptor);
    }

    public <S, T> MapState<S, T> getMapState(MapStateDescriptor<S, T> stateDescriptor) {
        this.stateSanityCheck((AbstractStateDescriptor)stateDescriptor, (AbstractKeyStateBackend)this.keyStateBackend);
        return this.keyStateBackend.getMapState(stateDescriptor);
    }

    protected void stateSanityCheck(AbstractStateDescriptor stateDescriptor, AbstractKeyStateBackend backend) {
        Preconditions.checkNotNull((Object)stateDescriptor, (Object)"The state properties must not be null");
        Preconditions.checkNotNull((Object)backend, (Object)"backend must not be null");
    }
}

