/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.context.impl;

import io.ray.streaming.runtime.config.global.ContextBackendConfig;
import io.ray.streaming.runtime.context.ContextBackend;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryContextBackend
implements ContextBackend {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryContextBackend.class);
    private final Map<String, byte[]> kvStore = new HashMap<String, byte[]>();

    public MemoryContextBackend(ContextBackendConfig config) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Start init memory state backend, config is {}.", (Object)config);
            LOG.info("Finish init memory state backend.");
        }
    }

    @Override
    public boolean exists(String key) {
        return this.kvStore.containsKey(key);
    }

    @Override
    public byte[] get(String key) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Get value of key {} start.", (Object)key);
        }
        byte[] readData = this.kvStore.get(key);
        if (LOG.isInfoEnabled()) {
            LOG.info("Get value of key {} success.", (Object)key);
        }
        return readData;
    }

    @Override
    public void put(String key, byte[] value) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Put value of key {} start.", (Object)key);
        }
        this.kvStore.put(key, value);
        if (LOG.isInfoEnabled()) {
            LOG.info("Put value of key {} success.", (Object)key);
        }
    }

    @Override
    public void remove(String key) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Remove value of key {} start.", (Object)key);
        }
        this.kvStore.remove(key);
        if (LOG.isInfoEnabled()) {
            LOG.info("Remove value of key {} success.", (Object)key);
        }
    }
}

