/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.worker.context;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import io.ray.api.ActorHandle;
import io.ray.runtime.actor.NativeActorHandle;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import io.ray.streaming.runtime.generated.RemoteCall;
import io.ray.streaming.runtime.master.JobMaster;
import io.ray.streaming.runtime.python.GraphPbBuilder;
import java.io.Serializable;
import java.util.Map;

public class JobWorkerContext
implements Serializable {
    private ActorHandle<JobMaster> master;
    private ExecutionVertex executionVertex;

    public JobWorkerContext(ActorHandle<JobMaster> master, ExecutionVertex executionVertex) {
        this.master = master;
        this.executionVertex = executionVertex;
    }

    public int getWorkerId() {
        return this.executionVertex.getExecutionVertexId();
    }

    public String getWorkerName() {
        return this.executionVertex.getExecutionVertexName();
    }

    public Map<String, String> getConfig() {
        return this.executionVertex.getWorkerConfig();
    }

    public ActorHandle<JobMaster> getMaster() {
        return this.master;
    }

    public ExecutionVertex getExecutionVertex() {
        return this.executionVertex;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("workerId", this.getWorkerId()).add("workerName", (Object)this.getWorkerName()).add("config", this.getConfig()).toString();
    }

    public byte[] getPythonWorkerContextBytes() {
        RemoteCall.ExecutionVertexContext executionVertexContext = new GraphPbBuilder().buildExecutionVertexContext(this.executionVertex);
        byte[] contextBytes = RemoteCall.PythonJobWorkerContext.newBuilder().setMasterActor(ByteString.copyFrom((byte[])((NativeActorHandle)this.master).toBytes())).setExecutionVertexContext(executionVertexContext).build().toByteArray();
        return contextBytes;
    }
}

