/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.transfer;

import io.ray.runtime.RayNativeRuntime;
import io.ray.runtime.util.JniUtils;

public class TransferHandler {
    private long writerClientNative = this.createWriterClientNative();
    private long readerClientNative = this.createReaderClientNative();

    public void onWriterMessage(byte[] buffer) {
        this.handleWriterMessageNative(this.writerClientNative, buffer);
    }

    public byte[] onWriterMessageSync(byte[] buffer) {
        return this.handleWriterMessageSyncNative(this.writerClientNative, buffer);
    }

    public void onReaderMessage(byte[] buffer) {
        this.handleReaderMessageNative(this.readerClientNative, buffer);
    }

    public byte[] onReaderMessageSync(byte[] buffer) {
        return this.handleReaderMessageSyncNative(this.readerClientNative, buffer);
    }

    private native long createWriterClientNative();

    private native long createReaderClientNative();

    private native void handleWriterMessageNative(long var1, byte[] var3);

    private native byte[] handleWriterMessageSyncNative(long var1, byte[] var3);

    private native void handleReaderMessageNative(long var1, byte[] var3);

    private native byte[] handleReaderMessageSyncNative(long var1, byte[] var3);

    static {
        try {
            Class.forName(RayNativeRuntime.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        JniUtils.loadLibrary((String)"streaming_java");
    }
}

