/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.transfer;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.Set;
import sun.nio.ch.DirectBuffer;

public class ChannelId {
    public static final int ID_LENGTH = 20;
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = new FinalizableReferenceQueue();
    private static final Set<Reference<?>> references = Sets.newConcurrentHashSet();
    private final byte[] bytes;
    private final String strId;
    private final ByteBuffer buffer;
    private final long address;
    private final long nativeIdPtr;

    private ChannelId(String strId, byte[] idBytes) {
        this.strId = strId;
        this.bytes = idBytes;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(20);
        directBuffer.put(this.bytes);
        directBuffer.rewind();
        this.buffer = directBuffer;
        this.address = ((DirectBuffer)((Object)this.buffer)).address();
        long nativeIdPtr = 0L;
        this.nativeIdPtr = nativeIdPtr = ChannelId.createNativeId(this.address);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getAddress() {
        return this.address;
    }

    public long getNativeIdPtr() {
        if (this.nativeIdPtr == 0L) {
            throw new IllegalStateException("native ID not available");
        }
        return this.nativeIdPtr;
    }

    public String toString() {
        return this.strId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelId that = (ChannelId)o;
        return this.strId.equals(that.strId);
    }

    public int hashCode() {
        return this.strId.hashCode();
    }

    private static native long createNativeId(long var0);

    private static native void destroyNativeId(long var0);

    public static ChannelId from(String id) {
        return ChannelId.from(id, ChannelId.idStrToBytes(id));
    }

    public static ChannelId from(byte[] idBytes) {
        return ChannelId.from(ChannelId.idBytesToStr(idBytes), idBytes);
    }

    private static ChannelId from(String strID, byte[] idBytes) {
        ChannelId id = new ChannelId(strID, idBytes);
        final long nativeIdPtr = id.nativeIdPtr;
        if (nativeIdPtr != 0L) {
            FinalizablePhantomReference<ChannelId> reference = new FinalizablePhantomReference<ChannelId>(id, REFERENCE_QUEUE){

                public void finalizeReferent() {
                    ChannelId.destroyNativeId(nativeIdPtr);
                    references.remove((Object)this);
                }
            };
            references.add((Reference<?>)reference);
        }
        return id;
    }

    public static String genRandomIdStr() {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 40; ++i) {
            sb.append((char)(random.nextInt(6) + 65));
        }
        return sb.toString();
    }

    public static String genIdStr(int fromTaskId, int toTaskId, long ts) {
        Preconditions.checkArgument((fromTaskId < Short.MAX_VALUE ? 1 : 0) != 0, (String)"fromTaskId %d is larger than %d", (int)fromTaskId, (int)Short.MAX_VALUE);
        Preconditions.checkArgument((toTaskId < Short.MAX_VALUE ? 1 : 0) != 0, (String)"toTaskId %d is larger than %d", (int)fromTaskId, (int)Short.MAX_VALUE);
        byte[] channelName = new byte[20];
        for (int i = 11; i >= 8; --i) {
            channelName[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
        }
        channelName[16] = (byte)((fromTaskId & 0xFFFF) >> 8);
        channelName[17] = (byte)(fromTaskId & 0xFF);
        channelName[18] = (byte)((toTaskId & 0xFFFF) >> 8);
        channelName[19] = (byte)(toTaskId & 0xFF);
        return ChannelId.idBytesToStr(channelName);
    }

    static byte[] idStrToBytes(String id) {
        byte[] idBytes = BaseEncoding.base16().decode((CharSequence)id.toUpperCase());
        assert (idBytes.length == 20);
        return idBytes;
    }

    static String idBytesToStr(byte[] id) {
        assert (id.length == 20);
        return BaseEncoding.base16().encode(id).toLowerCase();
    }
}

