/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import io.ray.api.BaseActorHandle;
import io.ray.api.id.ActorId;
import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.VertexType;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.runtime.config.master.ResourceConfig;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertexState;
import io.ray.streaming.runtime.core.resource.ContainerID;
import io.ray.streaming.runtime.core.resource.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExecutionVertex
implements Serializable {
    private final int executionVertexId;
    private final int executionJobVertexId;
    private final String executionJobVertexName;
    private final StreamOperator streamOperator;
    private final VertexType vertexType;
    private final Language language;
    private final long buildTime;
    private final Map<String, Double> resource;
    private int parallelism;
    private int executionVertexIndex;
    private ExecutionVertexState state = ExecutionVertexState.TO_ADD;
    private ContainerID containerId;
    private BaseActorHandle workerActor;
    private Map<String, String> workerConfig;
    private List<ExecutionEdge> inputEdges = new ArrayList<ExecutionEdge>();
    private List<ExecutionEdge> outputEdges = new ArrayList<ExecutionEdge>();

    public ExecutionVertex(int globalIndex, int index, ExecutionJobVertex executionJobVertex, ResourceConfig resourceConfig) {
        this.executionVertexId = globalIndex;
        this.executionJobVertexId = executionJobVertex.getExecutionJobVertexId();
        this.executionJobVertexName = executionJobVertex.getExecutionJobVertexName();
        this.streamOperator = executionJobVertex.getStreamOperator();
        this.vertexType = executionJobVertex.getVertexType();
        this.language = executionJobVertex.getLanguage();
        this.buildTime = executionJobVertex.getBuildTime();
        this.parallelism = executionJobVertex.getParallelism();
        this.executionVertexIndex = index;
        this.resource = this.generateResources(resourceConfig);
        this.workerConfig = this.genWorkerConfig(executionJobVertex.getJobConfig());
    }

    private Map<String, String> genWorkerConfig(Map<String, String> jobConfig) {
        HashMap<String, String> workerConfig = new HashMap<String, String>();
        workerConfig.putAll(jobConfig);
        return workerConfig;
    }

    public int getExecutionVertexId() {
        return this.executionVertexId;
    }

    public String getExecutionVertexName() {
        return this.executionJobVertexName + "-" + this.executionVertexIndex;
    }

    public int getExecutionJobVertexId() {
        return this.executionJobVertexId;
    }

    public String getExecutionJobVertexName() {
        return this.executionJobVertexName;
    }

    public StreamOperator getStreamOperator() {
        return this.streamOperator;
    }

    public VertexType getVertexType() {
        return this.vertexType;
    }

    public Language getLanguage() {
        return this.language;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getExecutionVertexIndex() {
        return this.executionVertexIndex;
    }

    public ExecutionVertexState getState() {
        return this.state;
    }

    public void setState(ExecutionVertexState state) {
        this.state = state;
    }

    public boolean is2Add() {
        return this.state == ExecutionVertexState.TO_ADD;
    }

    public boolean isRunning() {
        return this.state == ExecutionVertexState.RUNNING;
    }

    public boolean is2Delete() {
        return this.state == ExecutionVertexState.TO_DEL;
    }

    public BaseActorHandle getWorkerActor() {
        return this.workerActor;
    }

    public ActorId getWorkerActorId() {
        return this.workerActor.getId();
    }

    public void setWorkerActor(BaseActorHandle workerActor) {
        this.workerActor = workerActor;
    }

    public List<ExecutionEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public List<ExecutionEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public List<ExecutionVertex> getInputVertices() {
        return this.inputEdges.stream().map(ExecutionEdge::getSourceExecutionVertex).collect(Collectors.toList());
    }

    public List<ExecutionVertex> getOutputVertices() {
        return this.outputEdges.stream().map(ExecutionEdge::getTargetExecutionVertex).collect(Collectors.toList());
    }

    public Map<String, Double> getResource() {
        return this.resource;
    }

    public Map<String, String> getWorkerConfig() {
        return this.workerConfig;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public ContainerID getContainerId() {
        return this.containerId;
    }

    public void setContainerId(ContainerID containerId) {
        this.containerId = containerId;
    }

    public void setContainerIfNotExist(ContainerID containerId) {
        if (null == this.containerId) {
            this.containerId = containerId;
        }
    }

    private Map<String, Double> generateResources(ResourceConfig resourceConfig) {
        HashMap<String, Double> resourceMap = new HashMap<String, Double>();
        if (resourceConfig.isTaskCpuResourceLimit()) {
            resourceMap.put(ResourceType.CPU.name(), resourceConfig.taskCpuResource());
        }
        if (resourceConfig.isTaskMemResourceLimit()) {
            resourceMap.put(ResourceType.MEM.name(), resourceConfig.taskMemResource());
        }
        return resourceMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionVertex) {
            return this.executionVertexId == ((ExecutionVertex)obj).getExecutionVertexId();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.executionVertexId, this.outputEdges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.executionVertexId).add("name", (Object)this.getExecutionVertexName()).add("resources", this.resource).add("state", (Object)this.state).add("containerId", (Object)this.containerId).add("workerActor", (Object)this.workerActor).toString();
    }
}

