/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.jobgraph.JobEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;

public class ExecutionJobEdge {
    private final ExecutionJobVertex sourceExecutionJobVertex;
    private final ExecutionJobVertex targetExecutionJobVertex;
    private final Partition partition;
    private final String executionJobEdgeIndex;

    public ExecutionJobEdge(ExecutionJobVertex sourceExecutionJobVertex, ExecutionJobVertex targetExecutionJobVertex, JobEdge jobEdge) {
        this.sourceExecutionJobVertex = sourceExecutionJobVertex;
        this.targetExecutionJobVertex = targetExecutionJobVertex;
        this.partition = jobEdge.getPartition();
        this.executionJobEdgeIndex = this.generateExecutionJobEdgeIndex();
    }

    private String generateExecutionJobEdgeIndex() {
        return this.sourceExecutionJobVertex.getExecutionJobVertexId() + "\u2014" + this.targetExecutionJobVertex.getExecutionJobVertexId();
    }

    public ExecutionJobVertex getSourceExecutionJobVertex() {
        return this.sourceExecutionJobVertex;
    }

    public ExecutionJobVertex getTargetExecutionJobVertex() {
        return this.targetExecutionJobVertex;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.sourceExecutionJobVertex).add("target", (Object)this.targetExecutionJobVertex).add("partition", (Object)this.partition).add("index", (Object)this.executionJobEdgeIndex).toString();
    }
}

