/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.python.stream;

import io.ray.streaming.api.Language;
import io.ray.streaming.api.context.StreamingContext;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.api.stream.DataStream;
import io.ray.streaming.api.stream.Stream;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.python.PythonFunction;
import io.ray.streaming.python.PythonOperator;
import io.ray.streaming.python.PythonPartition;
import io.ray.streaming.python.stream.PythonKeyDataStream;
import io.ray.streaming.python.stream.PythonStream;
import io.ray.streaming.python.stream.PythonStreamSink;
import io.ray.streaming.python.stream.PythonUnionStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PythonDataStream
extends Stream<PythonDataStream, Object>
implements PythonStream {
    protected PythonDataStream(StreamingContext streamingContext, PythonOperator pythonOperator) {
        super(streamingContext, (StreamOperator)pythonOperator);
    }

    protected PythonDataStream(StreamingContext streamingContext, PythonOperator pythonOperator, Partition<Object> partition) {
        super(streamingContext, (StreamOperator)pythonOperator, partition);
    }

    public PythonDataStream(PythonDataStream input, PythonOperator pythonOperator) {
        super(input, (StreamOperator)pythonOperator);
    }

    public PythonDataStream(PythonDataStream input, PythonOperator pythonOperator, Partition<Object> partition) {
        super(input, (StreamOperator)pythonOperator, partition);
    }

    public PythonDataStream(DataStream referencedStream) {
        super(referencedStream);
    }

    public PythonDataStream map(String moduleName, String funcName) {
        return this.map(new PythonFunction(moduleName, funcName));
    }

    public PythonDataStream map(PythonFunction func) {
        func.setFunctionInterface(PythonFunction.FunctionInterface.MAP_FUNCTION);
        return new PythonDataStream(this, new PythonOperator(func));
    }

    public PythonDataStream flatMap(String moduleName, String funcName) {
        return this.flatMap(new PythonFunction(moduleName, funcName));
    }

    public PythonDataStream flatMap(PythonFunction func) {
        func.setFunctionInterface(PythonFunction.FunctionInterface.FLAT_MAP_FUNCTION);
        return new PythonDataStream(this, new PythonOperator(func));
    }

    public PythonDataStream filter(String moduleName, String funcName) {
        return this.filter(new PythonFunction(moduleName, funcName));
    }

    public PythonDataStream filter(PythonFunction func) {
        func.setFunctionInterface(PythonFunction.FunctionInterface.FILTER_FUNCTION);
        return new PythonDataStream(this, new PythonOperator(func));
    }

    public final PythonDataStream union(PythonDataStream stream, PythonDataStream ... others) {
        ArrayList<PythonDataStream> streams = new ArrayList<PythonDataStream>();
        streams.add(stream);
        streams.addAll(Arrays.asList(others));
        return this.union(streams);
    }

    public final PythonDataStream union(List<PythonDataStream> streams) {
        if (this instanceof PythonUnionStream) {
            PythonUnionStream unionStream = (PythonUnionStream)this;
            streams.forEach(unionStream::addStream);
            return unionStream;
        }
        return new PythonUnionStream(this, streams);
    }

    public PythonStreamSink sink(String moduleName, String funcName) {
        return this.sink(new PythonFunction(moduleName, funcName));
    }

    public PythonStreamSink sink(PythonFunction func) {
        func.setFunctionInterface(PythonFunction.FunctionInterface.SINK_FUNCTION);
        return new PythonStreamSink(this, new PythonOperator(func));
    }

    public PythonKeyDataStream keyBy(String moduleName, String funcName) {
        return this.keyBy(new PythonFunction(moduleName, funcName));
    }

    public PythonKeyDataStream keyBy(PythonFunction func) {
        this.checkPartitionCall();
        func.setFunctionInterface(PythonFunction.FunctionInterface.KEY_FUNCTION);
        return new PythonKeyDataStream(this, new PythonOperator(func));
    }

    public PythonDataStream broadcast() {
        this.checkPartitionCall();
        return (PythonDataStream)this.setPartition(PythonPartition.BroadcastPartition);
    }

    public PythonDataStream partitionBy(PythonPartition partition) {
        this.checkPartitionCall();
        return (PythonDataStream)this.setPartition(partition);
    }

    private void checkPartitionCall() {
        if (this.getInputStream() != null && this.getInputStream().getLanguage() == Language.JAVA) {
            throw new RuntimeException("Partition related methods can't be called on a python stream if parent stream is a java stream.");
        }
    }

    public DataStream<Object> asJavaStream() {
        return new DataStream<Object>(this);
    }

    @Override
    public Language getLanguage() {
        return Language.PYTHON;
    }
}

