/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.python;

import com.google.common.base.Preconditions;
import io.ray.streaming.api.function.Function;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class PythonFunction
implements Function {
    private final byte[] function;
    private final String moduleName;
    private final String functionName;
    private String functionInterface;

    public PythonFunction(byte[] function) {
        Preconditions.checkNotNull((Object)function);
        this.function = function;
        this.moduleName = null;
        this.functionName = null;
    }

    public PythonFunction(String moduleName, String functionName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)moduleName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)functionName));
        this.function = null;
        this.moduleName = moduleName;
        this.functionName = functionName;
    }

    public void setFunctionInterface(FunctionInterface functionInterface) {
        this.functionInterface = functionInterface.functionInterface;
    }

    public byte[] getFunction() {
        return this.function;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionInterface() {
        return this.functionInterface;
    }

    public String toSimpleString() {
        if (this.function != null) {
            return "binary function";
        }
        return String.format("%s-%s.%s", this.functionInterface, this.moduleName, this.functionName);
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", PythonFunction.class.getSimpleName() + "[", "]");
        if (this.function != null) {
            stringJoiner.add("function=binary function");
        } else {
            stringJoiner.add("moduleName='" + this.moduleName + "'").add("functionName='" + this.functionName + "'");
        }
        stringJoiner.add("functionInterface='" + this.functionInterface + "'");
        return stringJoiner.toString();
    }

    public static enum FunctionInterface {
        SOURCE_FUNCTION("SourceFunction"),
        MAP_FUNCTION("MapFunction"),
        FLAT_MAP_FUNCTION("FlatMapFunction"),
        FILTER_FUNCTION("FilterFunction"),
        KEY_FUNCTION("KeyFunction"),
        REDUCE_FUNCTION("ReduceFunction"),
        SINK_FUNCTION("SinkFunction");

        private String functionInterface;

        private FunctionInterface(String functionInterface) {
            this.functionInterface = functionInterface;
        }
    }
}

