/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.api.stream;

import io.ray.streaming.api.function.impl.JoinFunction;
import io.ray.streaming.api.function.impl.KeyFunction;
import io.ray.streaming.api.stream.DataStream;
import io.ray.streaming.operator.impl.JoinOperator;
import java.io.Serializable;

public class JoinStream<L, R, O>
extends DataStream<L> {
    private final DataStream<R> rightStream;

    public JoinStream(DataStream<L> leftStream, DataStream<R> rightStream) {
        super(leftStream, new JoinOperator());
        this.rightStream = rightStream;
    }

    public DataStream<R> getRightStream() {
        return this.rightStream;
    }

    public <K> Where<K> where(KeyFunction<L, K> keyFunction) {
        return new Where<K>(this, keyFunction);
    }

    class Equal<K>
    implements Serializable {
        private JoinStream<L, R, O> joinStream;
        private KeyFunction<L, K> leftKeyByFunction;
        private KeyFunction<R, K> rightKeyByFunction;

        Equal(JoinStream<L, R, O> joinStream, KeyFunction<L, K> leftKeyByFunction, KeyFunction<R, K> rightKeyByFunction) {
            this.joinStream = joinStream;
            this.leftKeyByFunction = leftKeyByFunction;
            this.rightKeyByFunction = rightKeyByFunction;
        }

        public DataStream<O> with(JoinFunction<L, R, O> joinFunction) {
            JoinOperator joinOperator = (JoinOperator)this.joinStream.getOperator();
            joinOperator.setFunction(joinFunction);
            return this.joinStream;
        }
    }

    class Where<K>
    implements Serializable {
        private JoinStream<L, R, O> joinStream;
        private KeyFunction<L, K> leftKeyByFunction;

        Where(JoinStream<L, R, O> joinStream, KeyFunction<L, K> leftKeyByFunction) {
            this.joinStream = joinStream;
            this.leftKeyByFunction = leftKeyByFunction;
        }

        public Equal<K> equalTo(KeyFunction<R, K> rightKeyFunction) {
            return new Equal<K>(this.joinStream, this.leftKeyByFunction, rightKeyFunction);
        }
    }
}

