/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.api.stream;

import io.ray.streaming.api.stream.DataStream;
import io.ray.streaming.operator.impl.UnionOperator;
import java.util.ArrayList;
import java.util.List;

public class UnionStream<T>
extends DataStream<T> {
    private List<DataStream<T>> unionStreams = new ArrayList<DataStream<T>>();

    public UnionStream(DataStream<T> input, List<DataStream<T>> streams) {
        super(input, new UnionOperator());
        streams.forEach(this::addStream);
    }

    void addStream(DataStream<T> stream) {
        if (stream instanceof UnionStream) {
            this.unionStreams.addAll(((UnionStream)stream).getUnionStreams());
        } else {
            this.unionStreams.add(stream);
        }
    }

    public List<DataStream<T>> getUnionStreams() {
        return this.unionStreams;
    }
}

