/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.jobgraph;

import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.JobEdge;
import io.ray.streaming.jobgraph.JobVertex;
import io.ray.streaming.jobgraph.VertexType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobGraph
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(JobGraph.class);
    private final String jobName;
    private final Map<String, String> jobConfig;
    private List<JobVertex> jobVertices;
    private List<JobEdge> jobEdges;
    private String digraph;

    public JobGraph(String jobName, Map<String, String> jobConfig) {
        this.jobName = jobName;
        this.jobConfig = jobConfig;
        this.jobVertices = new ArrayList<JobVertex>();
        this.jobEdges = new ArrayList<JobEdge>();
    }

    public JobGraph(String jobName, Map<String, String> jobConfig, List<JobVertex> jobVertices, List<JobEdge> jobEdges) {
        this.jobName = jobName;
        this.jobConfig = jobConfig;
        this.jobVertices = jobVertices;
        this.jobEdges = jobEdges;
        this.generateDigraph();
    }

    public String generateDigraph() {
        StringBuilder digraph = new StringBuilder();
        digraph.append("digraph ").append(this.jobName).append(" ").append(" {");
        for (JobEdge jobEdge : this.jobEdges) {
            String srcNode = null;
            String targetNode = null;
            for (JobVertex jobVertex : this.jobVertices) {
                if (jobEdge.getSrcVertexId() == jobVertex.getVertexId()) {
                    srcNode = jobVertex.getVertexId() + "-" + jobVertex.getStreamOperator().getName();
                    continue;
                }
                if (jobEdge.getTargetVertexId() != jobVertex.getVertexId()) continue;
                targetNode = jobVertex.getVertexId() + "-" + jobVertex.getStreamOperator().getName();
            }
            digraph.append(System.getProperty("line.separator"));
            digraph.append(String.format("  \"%s\" -> \"%s\"", srcNode, targetNode));
        }
        digraph.append(System.getProperty("line.separator")).append("}");
        this.digraph = digraph.toString();
        return this.digraph;
    }

    public void addVertex(JobVertex vertex) {
        this.jobVertices.add(vertex);
    }

    public void addEdge(JobEdge jobEdge) {
        this.jobEdges.add(jobEdge);
    }

    public List<JobVertex> getJobVertices() {
        return this.jobVertices;
    }

    public List<JobVertex> getSourceVertices() {
        return this.jobVertices.stream().filter(v -> v.getVertexType() == VertexType.SOURCE).collect(Collectors.toList());
    }

    public List<JobVertex> getSinkVertices() {
        return this.jobVertices.stream().filter(v -> v.getVertexType() == VertexType.SINK).collect(Collectors.toList());
    }

    public JobVertex getVertex(int vertexId) {
        return this.jobVertices.stream().filter(v -> v.getVertexId() == vertexId).findFirst().get();
    }

    public List<JobEdge> getJobEdges() {
        return this.jobEdges;
    }

    public Set<JobEdge> getVertexInputEdges(int vertexId) {
        return this.jobEdges.stream().filter(jobEdge -> jobEdge.getTargetVertexId() == vertexId).collect(Collectors.toSet());
    }

    public Set<JobEdge> getVertexOutputEdges(int vertexId) {
        return this.jobEdges.stream().filter(jobEdge -> jobEdge.getSrcVertexId() == vertexId).collect(Collectors.toSet());
    }

    public String getDigraph() {
        return this.digraph;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, String> getJobConfig() {
        return this.jobConfig;
    }

    public void printJobGraph() {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        LOG.info("Printing job graph:");
        for (JobVertex jobVertex : this.jobVertices) {
            LOG.info(jobVertex.toString());
        }
        for (JobEdge jobEdge : this.jobEdges) {
            LOG.info(jobEdge.toString());
        }
    }

    public boolean isCrossLanguageGraph() {
        Language language = this.jobVertices.get(0).getLanguage();
        for (JobVertex jobVertex : this.jobVertices) {
            if (jobVertex.getLanguage() == language) continue;
            return true;
        }
        return false;
    }
}

