/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.api.stream;

import io.ray.streaming.api.Language;
import io.ray.streaming.api.context.StreamingContext;
import io.ray.streaming.api.function.impl.FilterFunction;
import io.ray.streaming.api.function.impl.FlatMapFunction;
import io.ray.streaming.api.function.impl.KeyFunction;
import io.ray.streaming.api.function.impl.MapFunction;
import io.ray.streaming.api.function.impl.SinkFunction;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.api.partition.impl.BroadcastPartition;
import io.ray.streaming.api.stream.DataStreamSink;
import io.ray.streaming.api.stream.JoinStream;
import io.ray.streaming.api.stream.KeyDataStream;
import io.ray.streaming.api.stream.Stream;
import io.ray.streaming.api.stream.UnionStream;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.operator.impl.FilterOperator;
import io.ray.streaming.operator.impl.FlatMapOperator;
import io.ray.streaming.operator.impl.KeyByOperator;
import io.ray.streaming.operator.impl.MapOperator;
import io.ray.streaming.operator.impl.SinkOperator;
import io.ray.streaming.python.stream.PythonDataStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataStream<T>
extends Stream<DataStream<T>, T> {
    public DataStream(StreamingContext streamingContext, StreamOperator streamOperator) {
        super(streamingContext, streamOperator);
    }

    public DataStream(StreamingContext streamingContext, StreamOperator streamOperator, Partition<T> partition) {
        super(streamingContext, streamOperator, partition);
    }

    public <R> DataStream(DataStream<R> input, StreamOperator streamOperator) {
        super(input, streamOperator);
    }

    public <R> DataStream(DataStream<R> input, StreamOperator streamOperator, Partition<T> partition) {
        super(input, streamOperator, partition);
    }

    public DataStream(PythonDataStream referencedStream) {
        super(referencedStream);
    }

    public <R> DataStream<R> map(MapFunction<T, R> mapFunction) {
        return new DataStream<T>(this, new MapOperator<T, R>(mapFunction));
    }

    public <R> DataStream<R> flatMap(FlatMapFunction<T, R> flatMapFunction) {
        return new DataStream<T>(this, new FlatMapOperator<T, R>(flatMapFunction));
    }

    public DataStream<T> filter(FilterFunction<T> filterFunction) {
        return new DataStream<T>(this, new FilterOperator<T>(filterFunction));
    }

    @SafeVarargs
    public final DataStream<T> union(DataStream<T> stream, DataStream<T> ... others) {
        ArrayList<DataStream<T>> streams = new ArrayList<DataStream<T>>();
        streams.add(stream);
        streams.addAll(Arrays.asList(others));
        return this.union(streams);
    }

    public final DataStream<T> union(List<DataStream<T>> streams) {
        if (this instanceof UnionStream) {
            UnionStream unionStream = (UnionStream)this;
            streams.forEach(unionStream::addStream);
            return unionStream;
        }
        return new UnionStream<T>(this, streams);
    }

    public <O, R> JoinStream<T, O, R> join(DataStream<O> other) {
        return new JoinStream(this, other);
    }

    public <R> DataStream<R> process() {
        return new DataStream<T>(this, null);
    }

    public DataStreamSink<T> sink(SinkFunction<T> sinkFunction) {
        return new DataStreamSink(this, new SinkOperator<T>(sinkFunction));
    }

    public <K> KeyDataStream<K, T> keyBy(KeyFunction<T, K> keyFunction) {
        this.checkPartitionCall();
        return new KeyDataStream(this, (StreamOperator)new KeyByOperator<T, K>(keyFunction));
    }

    public DataStream<T> broadcast() {
        this.checkPartitionCall();
        return (DataStream)this.setPartition(new BroadcastPartition());
    }

    public DataStream<T> partitionBy(Partition<T> partition) {
        this.checkPartitionCall();
        return (DataStream)this.setPartition(partition);
    }

    private void checkPartitionCall() {
        if (this.getInputStream() != null && this.getInputStream().getLanguage() == Language.PYTHON) {
            throw new RuntimeException("Partition related methods can't be called on a java stream if parent stream is a python stream.");
        }
    }

    public PythonDataStream asPythonStream() {
        return new PythonDataStream(this);
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }
}

