/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.api.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import io.ray.api.Ray;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.util.NetworkUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterStarter {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStarter.class);
    private static final String PLASMA_STORE_SOCKET_NAME = "/tmp/ray/plasma_store_socket";
    private static final String RAYLET_SOCKET_NAME = "/tmp/ray/raylet_socket";

    ClusterStarter() {
    }

    static synchronized void startCluster(boolean isCrossLanguage, boolean isLocal) {
        Preconditions.checkArgument((!Ray.isInitialized() ? 1 : 0) != 0);
        RayConfig.reset();
        if (!isLocal) {
            System.setProperty("ray.raylet.config.num_workers_per_process_java", "1");
            System.setProperty("ray.run-mode", "CLUSTER");
        } else {
            System.clearProperty("ray.raylet.config.num_workers_per_process_java");
            System.setProperty("ray.run-mode", "SINGLE_PROCESS");
        }
        if (!isCrossLanguage) {
            Ray.init();
            return;
        }
        for (String socket : ImmutableList.of((Object)RAYLET_SOCKET_NAME, (Object)PLASMA_STORE_SOCKET_NAME)) {
            File file = new File(socket);
            if (!file.exists()) continue;
            LOG.info("Delete existing socket file {}", (Object)file);
            file.delete();
        }
        String nodeManagerPort = String.valueOf(NetworkUtil.getUnusedPort());
        String classpath = Stream.of(System.getProperty("java.class.path").split(":")).filter(s -> !s.contains(" ") && s.contains("test")).collect(Collectors.joining(":"));
        String workerOptions = new Gson().toJson((Object)ImmutableList.of((Object)"-classpath", (Object)classpath));
        HashMap<String, String> config = new HashMap<String, String>(RayConfig.create().rayletConfigParameters);
        config.put("num_workers_per_process_java", "1");
        ImmutableList startCommand = ImmutableList.of((Object)"ray", (Object)"start", (Object)"--head", (Object)"--port=6379", (Object)String.format("--plasma-store-socket-name=%s", PLASMA_STORE_SOCKET_NAME), (Object)String.format("--raylet-socket-name=%s", RAYLET_SOCKET_NAME), (Object)String.format("--node-manager-port=%s", nodeManagerPort), (Object)"--load-code-from-local", (Object)("--java-worker-options=" + workerOptions), (Object)("--system-config=" + new Gson().toJson(config)));
        if (!ClusterStarter.executeCommand((List<String>)startCommand, 10)) {
            throw new RuntimeException("Couldn't start ray cluster.");
        }
        System.setProperty("ray.address", "127.0.0.1:6379");
        System.setProperty("ray.object-store.socket-name", PLASMA_STORE_SOCKET_NAME);
        System.setProperty("ray.raylet.socket-name", RAYLET_SOCKET_NAME);
        System.setProperty("ray.raylet.node-manager-port", nodeManagerPort);
        Ray.init();
    }

    public static synchronized void stopCluster(boolean isCrossLanguage) {
        ImmutableList stopCommand;
        Ray.shutdown();
        System.clearProperty("ray.address");
        System.clearProperty("ray.object-store.socket-name");
        System.clearProperty("ray.raylet.socket-name");
        System.clearProperty("ray.raylet.node-manager-port");
        System.clearProperty("ray.raylet.config.num_workers_per_process_java");
        System.clearProperty("ray.run-mode");
        if (isCrossLanguage && !ClusterStarter.executeCommand((List<String>)(stopCommand = ImmutableList.of((Object)"ray", (Object)"stop")), 10)) {
            throw new RuntimeException("Couldn't stop ray cluster");
        }
    }

    private static boolean executeCommand(List<String> command, int waitTimeoutSeconds) {
        LOG.info("Executing command: {}", (Object)String.join((CharSequence)" ", command));
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            boolean exit = process.waitFor(waitTimeoutSeconds, TimeUnit.SECONDS);
            if (!exit) {
                process.destroyForcibly();
            }
            return process.exitValue() == 0;
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing command " + String.join((CharSequence)" ", command), e);
        }
    }
}

