/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.python;

import com.google.common.base.Preconditions;
import io.ray.streaming.api.Language;
import io.ray.streaming.api.context.RuntimeContext;
import io.ray.streaming.api.function.Function;
import io.ray.streaming.operator.Operator;
import io.ray.streaming.operator.OperatorType;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.python.PythonFunction;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class PythonOperator
extends StreamOperator {
    private final String moduleName;
    private final String className;

    public PythonOperator(String moduleName, String className) {
        super(null);
        this.moduleName = moduleName;
        this.className = className;
    }

    public PythonOperator(PythonFunction function) {
        super(function);
        this.moduleName = null;
        this.className = null;
    }

    @Override
    public Language getLanguage() {
        return Language.PYTHON;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    public void open(List list, RuntimeContext runtimeContext) {
        this.throwUnsupportedException();
    }

    @Override
    public void finish() {
        this.throwUnsupportedException();
    }

    @Override
    public void close() {
        this.throwUnsupportedException();
    }

    void throwUnsupportedException() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        Preconditions.checkState((trace.length >= 2 ? 1 : 0) != 0);
        StackTraceElement traceElement = trace[2];
        String msg = String.format("Method %s.%s shouldn't be called.", traceElement.getClassName(), traceElement.getMethodName());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public OperatorType getOpType() {
        String msg = String.format("Methods of %s shouldn't be called.", this.getClass().getSimpleName());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append(PythonOperator.class.getSimpleName()).append("[");
        if (this.function != null) {
            builder.append(((PythonFunction)this.function).toSimpleString());
        } else {
            builder.append(this.moduleName).append(".").append(this.className);
        }
        return builder.append("]").toString();
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", PythonOperator.class.getSimpleName() + "[", "]");
        if (this.function != null) {
            stringJoiner.add("function='" + this.function + "'");
        } else {
            stringJoiner.add("moduleName='" + this.moduleName + "'").add("className='" + this.className + "'");
        }
        return stringJoiner.toString();
    }

    public static class ChainedPythonOperator
    extends PythonOperator {
        private final List<PythonOperator> operators;
        private final PythonOperator headOperator;
        private final PythonOperator tailOperator;
        private final List<Map<String, String>> configs;

        public ChainedPythonOperator(List<PythonOperator> operators, List<Map<String, String>> configs) {
            super(null);
            Preconditions.checkArgument((!operators.isEmpty() ? 1 : 0) != 0);
            this.operators = operators;
            this.configs = configs;
            this.headOperator = operators.get(0);
            this.tailOperator = operators.get(operators.size() - 1);
        }

        @Override
        public OperatorType getOpType() {
            return this.headOperator.getOpType();
        }

        @Override
        public Language getLanguage() {
            return Language.PYTHON;
        }

        @Override
        public String getName() {
            return this.operators.stream().map(Operator::getName).collect(Collectors.joining(" -> ", "[", "]"));
        }

        @Override
        public String getModuleName() {
            this.throwUnsupportedException();
            return null;
        }

        @Override
        public String getClassName() {
            this.throwUnsupportedException();
            return null;
        }

        @Override
        public Function getFunction() {
            this.throwUnsupportedException();
            return null;
        }

        public List<PythonOperator> getOperators() {
            return this.operators;
        }

        public PythonOperator getHeadOperator() {
            return this.headOperator;
        }

        public PythonOperator getTailOperator() {
            return this.tailOperator;
        }

        public List<Map<String, String>> getConfigs() {
            return this.configs;
        }
    }
}

