/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.concurrencygroup.ConcurrencyGroup;
import io.ray.api.options.BaseTaskOptions;
import io.ray.api.placementgroup.PlacementGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActorCreationOptions
extends BaseTaskOptions {
    public final boolean global;
    public final String name;
    public final int maxRestarts;
    public final List<String> jvmOptions;
    public final int maxConcurrency;
    public final PlacementGroup group;
    public final int bundleIndex;
    public final List<ConcurrencyGroup> concurrencyGroups;

    private ActorCreationOptions(boolean global, String name, Map<String, Double> resources, int maxRestarts, List<String> jvmOptions, int maxConcurrency, PlacementGroup group, int bundleIndex, List<ConcurrencyGroup> concurrencyGroups) {
        super(resources);
        this.global = global;
        this.name = name;
        this.maxRestarts = maxRestarts;
        this.jvmOptions = jvmOptions;
        this.maxConcurrency = maxConcurrency;
        this.group = group;
        this.bundleIndex = bundleIndex;
        this.concurrencyGroups = concurrencyGroups;
    }

    public static class Builder {
        private boolean global;
        private String name;
        private Map<String, Double> resources = new HashMap<String, Double>();
        private int maxRestarts = 0;
        private List<String> jvmOptions = new ArrayList<String>();
        private int maxConcurrency = 1;
        private PlacementGroup group;
        private int bundleIndex;
        private List<ConcurrencyGroup> concurrencyGroups = new ArrayList<ConcurrencyGroup>();

        public Builder setName(String name) {
            this.name = name;
            this.global = false;
            return this;
        }

        public Builder setGlobalName(String name) {
            this.name = name;
            this.global = true;
            return this;
        }

        public Builder setResource(String resourceName, Double resourceQuantity) {
            this.resources.put(resourceName, resourceQuantity);
            return this;
        }

        public Builder setResources(Map<String, Double> resources) {
            this.resources.putAll(resources);
            return this;
        }

        public Builder setMaxRestarts(int maxRestarts) {
            this.maxRestarts = maxRestarts;
            return this;
        }

        public Builder setJvmOptions(String jvmOptions) {
            this.jvmOptions = Arrays.asList(jvmOptions.split(" +"));
            return this;
        }

        public Builder setJvmOptions(List<String> jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public Builder setMaxConcurrency(int maxConcurrency) {
            if (maxConcurrency <= 0) {
                throw new IllegalArgumentException("maxConcurrency must be greater than 0.");
            }
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder setPlacementGroup(PlacementGroup group, int bundleIndex) {
            this.group = group;
            this.bundleIndex = bundleIndex;
            return this;
        }

        public ActorCreationOptions build() {
            return new ActorCreationOptions(this.global, this.name, this.resources, this.maxRestarts, this.jvmOptions, this.maxConcurrency, this.group, this.bundleIndex, this.concurrencyGroups);
        }

        public Builder setConcurrencyGroups(List<ConcurrencyGroup> concurrencyGroups) {
            this.concurrencyGroups = concurrencyGroups;
            return this;
        }
    }
}

