/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.placementgroup.PlacementStrategy;
import java.util.List;
import java.util.Map;

public class PlacementGroupCreationOptions {
    public final boolean global;
    public final String name;
    public final List<Map<String, Double>> bundles;
    public final PlacementStrategy strategy;

    public PlacementGroupCreationOptions(boolean global, String name, List<Map<String, Double>> bundles, PlacementStrategy strategy) {
        if (bundles == null || bundles.isEmpty()) {
            throw new IllegalArgumentException("`Bundles` must be specified when creating a new placement group.");
        }
        boolean bundleResourceValid = bundles.stream().allMatch(bundle -> bundle.values().stream().allMatch(resource -> resource > 0.0));
        if (!bundleResourceValid) {
            throw new IllegalArgumentException("Bundles cannot be empty or bundle's resource must be positive.");
        }
        if (strategy == null) {
            throw new IllegalArgumentException("`PlacementStrategy` must be specified when creating a new placement group.");
        }
        this.global = global;
        this.name = name;
        this.bundles = bundles;
        this.strategy = strategy;
    }

    public static class Builder {
        private boolean global;
        private String name;
        private List<Map<String, Double>> bundles;
        private PlacementStrategy strategy;

        public Builder setName(String name) {
            if (this.name != null) {
                throw new IllegalArgumentException("Repeated assignment of the name is not allowed!");
            }
            this.name = name;
            this.global = false;
            return this;
        }

        public Builder setGlobalName(String name) {
            if (this.name != null) {
                throw new IllegalArgumentException("Repeated assignment of the name is not allowed!");
            }
            this.name = name;
            this.global = true;
            return this;
        }

        public Builder setBundles(List<Map<String, Double>> bundles) {
            this.bundles = bundles;
            return this;
        }

        public Builder setStrategy(PlacementStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public PlacementGroupCreationOptions build() {
            return new PlacementGroupCreationOptions(this.global, this.name, this.bundles, this.strategy);
        }
    }
}

