/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.options.BaseTaskOptions;
import io.ray.api.placementgroup.PlacementGroup;
import java.util.HashMap;
import java.util.Map;

public class CallOptions
extends BaseTaskOptions {
    public final String name;
    public final PlacementGroup group;
    public final int bundleIndex;

    private CallOptions(String name, Map<String, Double> resources, PlacementGroup group, int bundleIndex) {
        super(resources);
        this.name = name;
        this.group = group;
        this.bundleIndex = bundleIndex;
    }

    public static class Builder {
        private String name;
        private Map<String, Double> resources = new HashMap<String, Double>();
        private PlacementGroup group;
        private int bundleIndex;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setResource(String name, Double value) {
            this.resources.put(name, value);
            return this;
        }

        public Builder setResources(Map<String, Double> resources) {
            this.resources.putAll(resources);
            return this;
        }

        public Builder setPlacementGroup(PlacementGroup group, int bundleIndex) {
            this.group = group;
            this.bundleIndex = bundleIndex;
            return this;
        }

        public CallOptions build() {
            return new CallOptions(this.name, this.resources, this.group, this.bundleIndex);
        }
    }
}

