/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api;

import io.ray.api.BaseActorHandle;
import io.ray.api.ObjectRef;
import io.ray.api.RayCall;
import io.ray.api.WaitResult;
import io.ray.api.runtime.RayRuntime;
import io.ray.api.runtime.RayRuntimeFactory;
import io.ray.api.runtimecontext.RuntimeContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;

public final class Ray
extends RayCall {
    private static RayRuntime runtime = null;

    public static void init() {
        try {
            Class<?> clz = Class.forName("io.ray.runtime.DefaultRayRuntimeFactory");
            RayRuntimeFactory factory = (RayRuntimeFactory)clz.newInstance();
            Ray.init(factory);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Ray runtime.", e);
        }
    }

    private static synchronized void init(RayRuntimeFactory factory) {
        if (runtime == null) {
            runtime = factory.createRayRuntime();
            Runtime.getRuntime().addShutdownHook(new Thread(Ray::shutdown));
        }
    }

    public static synchronized void shutdown() {
        if (runtime != null) {
            Ray.internal().shutdown();
            runtime = null;
        }
    }

    public static boolean isInitialized() {
        return runtime != null;
    }

    public static <T> ObjectRef<T> put(T obj) {
        return Ray.internal().put(obj);
    }

    public static <T> ObjectRef<T> put(T obj, BaseActorHandle owner) {
        return Ray.internal().put(obj, owner);
    }

    public static <T> T get(ObjectRef<T> objectRef, long timeoutMs) {
        return Ray.internal().get(objectRef, timeoutMs);
    }

    public static <T> T get(ObjectRef<T> objectRef) {
        return Ray.internal().get(objectRef);
    }

    public static <T> List<T> get(List<ObjectRef<T>> objectList, long timeoutMs) {
        return Ray.internal().get(objectList, timeoutMs);
    }

    public static <T> List<T> get(List<ObjectRef<T>> objectList) {
        return Ray.internal().get(objectList);
    }

    public static <T> WaitResult<T> wait(List<ObjectRef<T>> waitList, int numReturns, int timeoutMs, boolean fetchLocal) {
        return Ray.internal().wait(waitList, numReturns, timeoutMs, fetchLocal);
    }

    public static <T> WaitResult<T> wait(List<ObjectRef<T>> waitList, int numReturns, int timeoutMs) {
        return Ray.wait(waitList, numReturns, timeoutMs, true);
    }

    public static <T> WaitResult<T> wait(List<ObjectRef<T>> waitList, int numReturns) {
        return Ray.wait(waitList, numReturns, Integer.MAX_VALUE);
    }

    public static <T> WaitResult<T> wait(List<ObjectRef<T>> waitList) {
        return Ray.wait(waitList, waitList.size());
    }

    public static <T extends BaseActorHandle> Optional<T> getActor(String name) {
        return Ray.internal().getActor(name, null);
    }

    public static <T extends BaseActorHandle> Optional<T> getActor(String name, String namespace) {
        return Ray.internal().getActor(name, namespace);
    }

    public static Object getAsyncContext() {
        return Ray.internal().getAsyncContext();
    }

    public static void setAsyncContext(Object asyncContext) {
        Ray.internal().setAsyncContext(asyncContext);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        return Ray.internal().wrapRunnable(runnable);
    }

    public static <T> Callable<T> wrapCallable(Callable<T> callable) {
        return Ray.internal().wrapCallable(callable);
    }

    public static RayRuntime internal() {
        if (runtime == null) {
            throw new IllegalStateException("Ray has not been started yet. You can start Ray with 'Ray.init()'");
        }
        return runtime;
    }

    public static RuntimeContext getRuntimeContext() {
        return Ray.internal().getRuntimeContext();
    }

    public static void exitActor() {
        runtime.exitActor();
    }
}

