/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.runtime;

import io.ray.api.ActorHandle;
import io.ray.api.BaseActorHandle;
import io.ray.api.ObjectRef;
import io.ray.api.PyActorHandle;
import io.ray.api.WaitResult;
import io.ray.api.function.PyActorClass;
import io.ray.api.function.PyActorMethod;
import io.ray.api.function.PyFunction;
import io.ray.api.function.RayFunc;
import io.ray.api.id.ActorId;
import io.ray.api.id.UniqueId;
import io.ray.api.options.ActorCreationOptions;
import io.ray.api.options.CallOptions;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.placementgroup.PlacementStrategy;
import io.ray.api.runtimecontext.RuntimeContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;

public interface RayRuntime {
    public void shutdown();

    public <T> ObjectRef<T> put(T var1);

    public <T> T get(ObjectRef<T> var1);

    public <T> List<T> get(List<ObjectRef<T>> var1);

    public <T> WaitResult<T> wait(List<ObjectRef<T>> var1, int var2, int var3);

    public void free(List<ObjectRef<?>> var1, boolean var2, boolean var3);

    public void setResource(String var1, double var2, UniqueId var4);

    public <T extends BaseActorHandle> T getActorHandle(ActorId var1);

    public <T extends BaseActorHandle> Optional<T> getActor(String var1, boolean var2);

    public void killActor(BaseActorHandle var1, boolean var2);

    public ObjectRef call(RayFunc var1, Object[] var2, CallOptions var3);

    public ObjectRef call(PyFunction var1, Object[] var2, CallOptions var3);

    public ObjectRef callActor(ActorHandle<?> var1, RayFunc var2, Object[] var3);

    public ObjectRef callActor(PyActorHandle var1, PyActorMethod var2, Object[] var3);

    public <T> ActorHandle<T> createActor(RayFunc var1, Object[] var2, ActorCreationOptions var3);

    public PyActorHandle createActor(PyActorClass var1, Object[] var2, ActorCreationOptions var3);

    public PlacementGroup createPlacementGroup(List<Map<String, Double>> var1, PlacementStrategy var2);

    public RuntimeContext getRuntimeContext();

    public Object getAsyncContext();

    public void setAsyncContext(Object var1);

    public Runnable wrapRunnable(Runnable var1);

    public <T> Callable<T> wrapCallable(Callable<T> var1);

    public void exitActor();
}

