/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import java.util.HashMap;
import java.util.Map;

public abstract class BaseTaskOptions {
    public final Map<String, Double> resources;

    public BaseTaskOptions() {
        this.resources = new HashMap<String, Double>();
    }

    public BaseTaskOptions(Map<String, Double> resources) {
        for (Map.Entry<String, Double> entry : resources.entrySet()) {
            if (entry.getValue() == null || entry.getValue().compareTo(0.0) <= 0) {
                throw new IllegalArgumentException(String.format("Resource values should be positive. Specified resource: %s = %s.", entry.getKey(), entry.getValue()));
            }
            if (entry.getValue().compareTo(1.0) < 0 || entry.getValue().compareTo(Math.floor(entry.getValue())) == 0) continue;
            throw new IllegalArgumentException(String.format("A resource value should be an integer if it is greater than 1.0. Specified resource: %s = %s.", entry.getKey(), entry.getValue()));
        }
        this.resources = resources;
    }
}

