/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.id;

import io.ray.api.id.BaseId;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class UniqueId
extends BaseId
implements Serializable {
    public static final int LENGTH = 20;
    public static final UniqueId NIL = UniqueId.genNil();

    public static UniqueId fromHexString(String hex) {
        return new UniqueId(UniqueId.hexString2Bytes(hex));
    }

    public static UniqueId fromByteBuffer(ByteBuffer bb) {
        return new UniqueId(UniqueId.byteBuffer2Bytes(bb));
    }

    private static UniqueId genNil() {
        byte[] b = new byte[20];
        Arrays.fill(b, (byte)-1);
        return new UniqueId(b);
    }

    public static UniqueId randomId() {
        byte[] b = new byte[20];
        new Random().nextBytes(b);
        return new UniqueId(b);
    }

    public UniqueId(byte[] id) {
        super(id);
    }

    @Override
    public int size() {
        return 20;
    }
}

