/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.id;

import io.ray.api.id.BaseId;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class ObjectId
extends BaseId
implements Serializable {
    public static final int LENGTH = 20;

    public static ObjectId fromByteBuffer(ByteBuffer bb) {
        return new ObjectId(ObjectId.byteBuffer2Bytes(bb));
    }

    public static ObjectId fromRandom() {
        byte[] b = new byte[20];
        new Random().nextBytes(b);
        Arrays.fill(b, 16, 20, (byte)0);
        return new ObjectId(b);
    }

    public ObjectId(byte[] id) {
        super(id);
    }

    @Override
    public int size() {
        return 20;
    }
}

