/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf3.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import ratpack.config.FileSystemBinding;
import ratpack.thymeleaf3.internal.PathTemplateResource;

public final class FileSystemBindingThymeleaf3TemplateResolver
extends AbstractConfigurableTemplateResolver {
    private final FileSystemBinding fileSystemBinding;

    public FileSystemBindingThymeleaf3TemplateResolver(FileSystemBinding fileSystemBinding) {
        this.fileSystemBinding = fileSystemBinding;
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        Path path = this.fileSystemBinding.file(resourceName);
        if (path == null) {
            return null;
        }
        Charset charset = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(characterEncoding);
        return new PathTemplateResource(template, path, charset);
    }
}

