/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf3;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;
import ratpack.core.server.ServerConfig;
import ratpack.guice.ConfigurableModule;
import ratpack.thymeleaf3.internal.FileSystemBindingThymeleaf3TemplateResolver;
import ratpack.thymeleaf3.internal.Thymeleaf3TemplateRenderer;

public final class ThymeleafModule
extends ConfigurableModule<Config> {
    public static final String DEFAULT_TEMPLATE_MODE = "HTML";
    public static final String DEFAULT_TEMPLATE_PREFIX = "thymeleaf";
    public static final String DEFAULT_TEMPLATE_SUFFIX = ".html";
    private String templatesMode;
    private String templatesPrefix;
    private String templatesSuffix;

    public String getTemplatesMode() {
        return this.templatesMode;
    }

    public String getTemplatesPrefix() {
        return this.templatesPrefix;
    }

    public String getTemplatesSuffix() {
        return this.templatesSuffix;
    }

    public void setTemplatesMode(String templatesMode) {
        this.templatesMode = templatesMode;
    }

    public void setTemplatesPrefix(String templatesPrefix) {
        this.templatesPrefix = templatesPrefix;
    }

    public void setTemplatesSuffix(String templatesSuffix) {
        this.templatesSuffix = templatesSuffix;
    }

    protected void configure() {
        this.bind(Thymeleaf3TemplateRenderer.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    ITemplateResolver provideTemplateResolver(ServerConfig serverConfig, Config config) {
        FileSystemBindingThymeleaf3TemplateResolver resolver = new FileSystemBindingThymeleaf3TemplateResolver(serverConfig.getBaseDir());
        resolver.setTemplateMode(this.getTemplatesModeSetting(config));
        resolver.setPrefix(this.getTemplatesPrefixSetting(config));
        resolver.setSuffix(this.getTemplatesSuffixSetting(config));
        return resolver;
    }

    @Provides
    @Singleton
    TemplateEngine provideTemplateEngine(ITemplateResolver templateResolver) {
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver(templateResolver);
        return templateEngine;
    }

    private String getTemplatesModeSetting(Config config) {
        return Strings.isNullOrEmpty((String)this.getTemplatesMode()) ? config.getTemplatesMode() : this.getTemplatesMode();
    }

    private String getTemplatesPrefixSetting(Config config) {
        String prefix = Strings.isNullOrEmpty((String)this.getTemplatesPrefix()) ? config.getTemplatesPrefix() : this.getTemplatesPrefix();
        return prefix.endsWith(File.separator) ? prefix : prefix + File.separator;
    }

    private String getTemplatesSuffixSetting(Config config) {
        String suffix = Strings.isNullOrEmpty((String)this.getTemplatesSuffix()) ? config.getTemplatesSuffix() : this.getTemplatesSuffix();
        return Strings.isNullOrEmpty((String)suffix) ? DEFAULT_TEMPLATE_SUFFIX : suffix;
    }

    public static class Config {
        private String templatesMode = "HTML";
        private String templatesPrefix = "thymeleaf";
        private String templatesSuffix = ".html";

        public String getTemplatesMode() {
            return this.templatesMode;
        }

        public String getTemplatesPrefix() {
            return this.templatesPrefix;
        }

        public String getTemplatesSuffix() {
            return this.templatesSuffix;
        }

        public Config templatesMode(String templatesMode) {
            this.templatesMode = templatesMode;
            return this;
        }

        public Config templatesPrefix(String templatesPrefix) {
            this.templatesPrefix = templatesPrefix;
            return this;
        }

        public Config templateSuffix(String templatesSuffix) {
            this.templatesSuffix = templatesSuffix;
            return this;
        }
    }
}

