/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf3.internal;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.thymeleaf.templateresource.ITemplateResource;

public final class PathTemplateResource
implements ITemplateResource {
    private final String name;
    private final Path path;
    private final Charset charset;

    public PathTemplateResource(String name, Path path, Charset encoding) {
        this.name = name;
        this.path = path;
        this.charset = encoding;
    }

    public String getDescription() {
        return this.path.toAbsolutePath().toString();
    }

    public String getBaseName() {
        return this.name;
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public Reader reader() throws IOException {
        return Files.newBufferedReader(this.path, this.charset);
    }

    public ITemplateResource relative(String relativeLocation) {
        return new PathTemplateResource(this.name, this.path.getParent().resolve(relativeLocation), this.charset);
    }
}

