/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ratpack.func.Exceptions;
import ratpack.session.clientside.Signer;

public class DefaultSigner
implements Signer {
    private final SecretKeySpec secretKeySpec;

    public DefaultSigner(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    @Override
    public ByteBuf sign(ByteBuf message, ByteBufAllocator byteBufAllocator) {
        return (ByteBuf)Exceptions.uncheck(() -> {
            Mac mac = Mac.getInstance(this.secretKeySpec.getAlgorithm());
            mac.init(this.secretKeySpec);
            mac.update(message.nioBuffer());
            return Unpooled.wrappedBuffer((byte[])mac.doFinal());
        });
    }
}

