/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session;

import java.util.Objects;
import ratpack.api.Nullable;
import ratpack.session.internal.DefaultSessionKey;
import ratpack.util.Types;

public interface SessionKey<T> {
    @Nullable
    public String getName();

    @Nullable
    public Class<T> getType();

    public static <T> SessionKey<T> of(Class<T> type) {
        return SessionKey.of(null, type);
    }

    public static <T> SessionKey<T> of(@Nullable String name, @Nullable Class<T> type) {
        if (name == null && type == null) {
            throw new IllegalArgumentException("one of name or type must not be null");
        }
        return new DefaultSessionKey<T>(name, type);
    }

    public static SessionKey<?> of(String name) {
        return SessionKey.of(Objects.requireNonNull(name, "name cannot be null"), null);
    }

    public static <T> SessionKey<T> ofType(String name, T value) {
        Class type = (Class)Types.cast(value.getClass());
        return SessionKey.of(name, type);
    }

    public static <T> SessionKey<T> ofType(T value) {
        return SessionKey.ofType(null, value);
    }
}

