/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.Optional;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.session.SessionCookieConfig;
import ratpack.session.SessionId;
import ratpack.session.SessionIdGenerator;

public class CookieBasedSessionId
implements SessionId {
    private final Request request;
    private final Response response;
    private final SessionIdGenerator sessionIdGenerator;
    private final SessionCookieConfig cookieConfig;
    private AsciiString assignedCookieId;
    private Optional<AsciiString> cookieSessionId;

    public CookieBasedSessionId(Request request, Response response, SessionIdGenerator sessionIdGenerator, SessionCookieConfig cookieConfig) {
        this.request = request;
        this.response = response;
        this.sessionIdGenerator = sessionIdGenerator;
        this.cookieConfig = cookieConfig;
    }

    @Override
    public AsciiString getValue() {
        if (this.assignedCookieId != null) {
            return this.assignedCookieId;
        }
        return this.getCookieSessionId().orElseGet(() -> {
            this.assignedCookieId = this.assignId();
            return this.assignedCookieId;
        });
    }

    private Optional<AsciiString> getCookieSessionId() {
        if (this.cookieSessionId == null) {
            Cookie match = null;
            for (Cookie cookie : this.request.getCookies()) {
                if (!cookie.name().equals(this.cookieConfig.getIdName())) continue;
                match = cookie;
                break;
            }
            this.cookieSessionId = match == null ? Optional.empty() : Optional.of(AsciiString.of((CharSequence)match.value()));
        }
        return this.cookieSessionId;
    }

    private AsciiString assignId() {
        AsciiString id = this.sessionIdGenerator.generateSessionId();
        this.setCookie(id.toString(), this.cookieConfig.getExpires());
        return id;
    }

    private void setCookie(String value, Duration expiration) {
        long expirySeconds;
        String cookiePath;
        DefaultCookie cookie = new DefaultCookie(this.cookieConfig.getIdName(), value);
        String cookieDomain = this.cookieConfig.getDomain();
        if (cookieDomain != null) {
            cookie.setDomain(cookieDomain);
        }
        if ((cookiePath = this.cookieConfig.getPath()) != null) {
            cookie.setPath(cookiePath);
        }
        long l = expirySeconds = expiration == null ? 0L : expiration.getSeconds();
        if (expirySeconds > 0L) {
            cookie.setMaxAge(expirySeconds);
        }
        cookie.setHttpOnly(this.cookieConfig.isHttpOnly());
        cookie.setSecure(this.cookieConfig.isSecure());
        this.response.getCookies().add(cookie);
    }

    @Override
    public void terminate() {
        this.setCookie("", Duration.ZERO);
        this.cookieSessionId = null;
        this.assignedCookieId = null;
    }
}

