/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import ratpack.exec.Operation;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.Session;
import ratpack.session.SessionKey;
import ratpack.session.SessionSerializer;

public interface SessionData {
    public Set<SessionKey<?>> getKeys();

    default public <T> Optional<T> get(SessionKey<T> key) {
        return this.get(key, this.getDefaultSerializer());
    }

    public <T> Optional<T> get(SessionKey<T> var1, SessionSerializer var2);

    default public Optional<?> get(String name) {
        return this.get(SessionKey.of(name));
    }

    default public Optional<?> get(String name, SessionSerializer serializer) {
        return this.get(SessionKey.of(name), serializer);
    }

    default public <T> Optional<T> get(Class<T> type) {
        return this.get(SessionKey.of(type));
    }

    default public <T> Optional<T> get(Class<T> type, SessionSerializer serializer) {
        return this.get(SessionKey.of(type), serializer);
    }

    default public <T> T require(SessionKey<T> key) {
        return this.require(key, this.getDefaultSerializer());
    }

    default public <T> T require(SessionKey<T> key, SessionSerializer serializer) {
        return this.get(key, serializer).orElseThrow(() -> new NoSuchElementException("No object for " + key + " in session"));
    }

    default public <T> T require(Class<T> type) {
        return this.require(SessionKey.of(type));
    }

    default public <T> T require(Class<T> type, SessionSerializer serializer) {
        return this.require(SessionKey.of(type), serializer);
    }

    default public Object require(String name) {
        return this.require(SessionKey.of(name));
    }

    default public Object require(String name, SessionSerializer serializer) {
        return this.require(SessionKey.of(name), serializer);
    }

    default public <T> void set(SessionKey<T> key, T value) {
        this.set(key, value, this.getDefaultSerializer());
    }

    public <T> void set(SessionKey<T> var1, T var2, SessionSerializer var3);

    default public <T> void set(Class<T> type, T value) {
        this.set(SessionKey.of(type), value);
    }

    default public <T> void set(Class<T> type, T value, SessionSerializer serializer) {
        this.set(SessionKey.of(type), value, serializer);
    }

    default public <T> void set(String name, T value) {
        this.set(SessionKey.ofType(name, value), value, this.getDefaultSerializer());
    }

    default public <T> void set(String name, T value, SessionSerializer serializer) {
        this.set(SessionKey.ofType(name, value), value, serializer);
    }

    default public <T> void set(T value) {
        this.set(SessionKey.ofType(value), value, this.getDefaultSerializer());
    }

    default public <T> void set(T value, SessionSerializer serializer) {
        this.set(SessionKey.ofType(value), value, serializer);
    }

    public void remove(SessionKey<?> var1);

    default public void remove(Class<?> type) {
        this.remove(SessionKey.of(type));
    }

    default public void remove(String name) {
        this.remove(SessionKey.of(name));
    }

    public void clear();

    public Session getSession();

    default public boolean isDirty() {
        return this.getSession().isDirty();
    }

    default public Operation save() {
        return this.getSession().save();
    }

    default public Operation terminate() {
        return this.getSession().terminate();
    }

    default public SessionSerializer getDefaultSerializer() {
        return this.getSession().getDefaultSerializer();
    }

    default public JavaSessionSerializer getJavaSerializer() {
        return this.getSession().getJavaSerializer();
    }
}

