/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.store;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import javax.inject.Singleton;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.handling.Handler;
import ratpack.session.SessionManager;
import ratpack.session.store.SessionStore;
import ratpack.session.store.internal.DefaultSessionStore;
import ratpack.session.store.internal.SessionStorageBindingHandler;

public class MapSessionsModule
extends AbstractModule
implements HandlerDecoratingModule {
    private final int maxEntries;
    private final int idleTimeoutMinutes;

    public MapSessionsModule(int maxEntries, int idleTimeoutMinutes) {
        this.maxEntries = maxEntries;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    protected void configure() {
    }

    @Provides
    @Singleton
    SessionStore provideMapSessionStore(SessionManager sessionManager) {
        DefaultSessionStore defaultMapSessionStore = new DefaultSessionStore(this.maxEntries, this.idleTimeoutMinutes);
        sessionManager.addSessionListener(defaultMapSessionStore);
        return defaultMapSessionStore;
    }

    public Handler decorate(Injector injector, Handler handler) {
        return new SessionStorageBindingHandler(handler);
    }
}

