/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.serialization.kryo;

import com.esotericsoftware.kryo.kryo5.ClassResolver;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.KryoObjectInput;
import com.esotericsoftware.kryo.kryo5.io.KryoObjectOutput;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.ExternalizableSerializer;
import com.esotericsoftware.kryo.kryo5.util.DefaultClassResolver;
import com.google.inject.Singleton;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.Externalizable;
import java.io.InputStream;
import java.io.OutputStream;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.SessionTypeFilter;

@Singleton
public class KryoSessionSerializer
implements JavaSessionSerializer {
    private static final FastThreadLocal<KryoRef> KRYO = new FastThreadLocal();

    private Kryo kryo(SessionTypeFilter typeFilter) {
        KryoRef kryoRef = (KryoRef)KRYO.get();
        if (kryoRef == null || !kryoRef.filter.equals(typeFilter)) {
            kryoRef = new KryoRef(typeFilter, this.createKryo(typeFilter));
            KRYO.set((Object)kryoRef);
        }
        return kryoRef.kryo;
    }

    private Kryo createKryo(SessionTypeFilter filter) {
        Kryo kryo = new Kryo((ClassResolver)new FilteringClassResolver(filter), null);
        kryo.setRegistrationRequired(false);
        kryo.addDefaultSerializer(Externalizable.class, (Serializer)new ExternalizableSerializer());
        this.configureKryo(kryo);
        return kryo;
    }

    protected void configureKryo(Kryo kryo) {
    }

    public <T> void serialize(Class<T> type, T value, OutputStream out, SessionTypeFilter typeFilter) throws Exception {
        try (KryoObjectOutput objectOut = new KryoObjectOutput(this.kryo(typeFilter), new Output(out));){
            objectOut.writeObject(value);
        }
    }

    public <T> T deserialize(Class<T> type, InputStream in, SessionTypeFilter typeFilter) throws Exception {
        try (KryoObjectInput objectInput = new KryoObjectInput(this.kryo(typeFilter), new Input(in));){
            Object obj = objectInput.readObject();
            if (type.isInstance(obj)) {
                T t = type.cast(obj);
                return t;
            }
            throw new IllegalStateException("Expected " + type + " got " + obj.getClass());
        }
    }

    private static final class FilteringClassResolver
    extends DefaultClassResolver {
        private final SessionTypeFilter filter;

        FilteringClassResolver(SessionTypeFilter filter) {
            this.filter = filter;
        }

        protected void writeName(Output output, Class type, Registration registration) {
            this.filter.assertAllowed(type.getName());
            super.writeName(output, type, registration);
        }

        protected Registration readName(Input input) {
            Registration registration = super.readName(input);
            this.filter.assertAllowed(registration.getType().getName());
            return registration;
        }
    }

    private static final class KryoRef {
        private final SessionTypeFilter filter;
        private final Kryo kryo;

        KryoRef(SessionTypeFilter filter, Kryo kryo) {
            this.filter = filter;
            this.kryo = kryo;
        }
    }
}

