/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.store.internal;

import com.google.inject.Inject;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.async.RedisAsyncCommands;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import ratpack.exec.Execution;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.server.StartEvent;
import ratpack.server.StopEvent;
import ratpack.session.SessionStore;
import ratpack.session.store.RedisSessionModule;
import ratpack.session.store.internal.AsciiStringByteBufRedisCodec;
import ratpack.session.store.internal.TimerExposingRedisClient;

public class RedisSessionStore
implements SessionStore {
    private final RedisSessionModule.Config config;
    private TimerExposingRedisClient redisClient;
    private RedisAsyncCommands<AsciiString, ByteBuf> connection;

    @Inject
    public RedisSessionStore(RedisSessionModule.Config config) {
        this.config = config;
    }

    public Operation store(AsciiString sessionId, ByteBuf sessionData) {
        return Promise.of(d -> this.connection.set((Object)sessionId, (Object)sessionData).handleAsync((value, failure) -> {
            if (failure == null) {
                if (value != null && value.equalsIgnoreCase("OK")) {
                    d.success((Object)true);
                } else {
                    d.error((Throwable)new RuntimeException("Failed to set session data"));
                }
            } else {
                d.error((Throwable)new RuntimeException("Failed to set session data.", (Throwable)failure));
            }
            return null;
        }, (Executor)Execution.current().getEventLoop())).operation();
    }

    public Promise<ByteBuf> load(AsciiString sessionId) {
        return Promise.of(downstream -> downstream.accept((CompletionStage)this.connection.get((Object)sessionId))).map(byteBuf -> {
            if (byteBuf == null) {
                return Unpooled.EMPTY_BUFFER;
            }
            return byteBuf;
        });
    }

    public Operation remove(AsciiString sessionId) {
        return Promise.of(d -> d.accept((CompletionStage)this.connection.del((Object[])new AsciiString[]{sessionId}))).operation();
    }

    public Promise<Long> size() {
        return Promise.value((Object)-1L);
    }

    public String getName() {
        return "Redis Session Store Service";
    }

    public void onStart(StartEvent event) throws Exception {
        this.redisClient = new TimerExposingRedisClient(this.getRedisURI());
        this.connection = this.redisClient.connect(new AsciiStringByteBufRedisCodec()).async();
    }

    public void onStop(StopEvent event) throws Exception {
        if (this.redisClient != null) {
            try {
                this.redisClient.getTimer().stop();
                this.redisClient.shutdown();
            }
            finally {
                this.redisClient = null;
            }
        }
    }

    private RedisURI getRedisURI() {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)this.config.getHost());
        if (this.config.getPassword() != null) {
            builder.withPassword(this.config.getPassword());
        }
        if (this.config.getPort() != null) {
            builder.withPort(this.config.getPort().intValue());
        }
        return builder.build();
    }
}

