/*
 * Decompiled with CFR 0.152.
 */
package ratpack.rocker.internal;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.runtime.ArrayOfByteArraysOutput;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import java.util.List;
import ratpack.core.handling.Context;
import ratpack.core.render.RendererException;
import ratpack.core.render.RendererSupport;
import ratpack.rocker.RockerRenderer;

@Singleton
public final class DefaultRockerRenderer
extends RendererSupport<RockerModel>
implements RockerRenderer {
    private static final AsciiString HTML = AsciiString.of((CharSequence)"text/html;charset=UTF-8");
    private static final AsciiString TEXT = AsciiString.of((CharSequence)"text/plain;charset=UTF-8");
    public static final RockerRenderer INSTANCE = new DefaultRockerRenderer();

    public void render(Context context, RockerModel rockerModel) throws Exception {
        try {
            ArrayOfByteArraysOutput output = (ArrayOfByteArraysOutput)rockerModel.render(ArrayOfByteArraysOutput.FACTORY);
            List arrays = output.getArrays();
            int size = arrays.size();
            Object byteBuf = size == 0 ? Unpooled.EMPTY_BUFFER : (size == 1 ? Unpooled.wrappedBuffer((byte[])((byte[])arrays.get(0))) : new CompositeByteBuf(ByteBufAllocator.DEFAULT, false, size, Iterables.transform((Iterable)arrays, Unpooled::wrappedBuffer)));
            AsciiString contentType = output.getContentType() == ContentType.HTML ? HTML : TEXT;
            context.getResponse().contentTypeIfNotSet((CharSequence)contentType).send(byteBuf);
        }
        catch (Exception e) {
            throw new RendererException("Error rendering template " + rockerModel.getClass().getName(), (Throwable)e);
        }
    }
}

