/*
 * Decompiled with CFR 0.152.
 */
package ratpack.reactor.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecController;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.NonNull;

public abstract class ExecutorBackedScheduler
implements Scheduler {
    protected final ExecController execController;
    protected final Scheduler delegateScheduler;

    protected ExecutorBackedScheduler(ExecController execController) {
        this.execController = execController;
        this.delegateScheduler = Schedulers.fromExecutor((Executor)this.getExecutor());
    }

    abstract ExecutorService getExecutor();

    public long now(@NonNull TimeUnit unit) {
        return this.delegateScheduler.now(unit);
    }

    public Disposable schedule(Runnable runnable) {
        return this.delegateScheduler.schedule(runnable);
    }

    public Scheduler.Worker createWorker() {
        return new Scheduler.Worker(){
            private final Scheduler.Worker delegateWorker;
            {
                this.delegateWorker = ExecutorBackedScheduler.this.delegateScheduler.createWorker();
            }

            public Disposable schedule(@NonNull Runnable run) {
                return this.delegateWorker.schedule((Runnable)new ExecutionWrappedAction(run));
            }

            public Disposable schedule(@NonNull Runnable run, long delayTime, TimeUnit unit) {
                return this.delegateWorker.schedule((Runnable)new ExecutionWrappedAction(run), delayTime, unit);
            }

            public void dispose() {
                this.delegateWorker.dispose();
            }

            public boolean isDisposed() {
                return this.delegateWorker.isDisposed();
            }

            class ExecutionWrappedAction
            implements Runnable {
                private final Runnable delegate;

                ExecutionWrappedAction(Runnable delegate) {
                    this.delegate = delegate;
                }

                @Override
                public void run() {
                    ExecutorBackedScheduler.this.execController.fork().start(execution -> this.delegate.run());
                }
            }
        };
    }
}

