/*
 * Decompiled with CFR 0.152.
 */
package ratpack.newrelic.internal;

import com.newrelic.api.agent.Trace;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.func.Block;
import ratpack.handling.Context;
import ratpack.newrelic.NewRelicTransaction;
import ratpack.newrelic.internal.DefaultNewRelicTransaction;

public class NewRelicExecInterceptor
implements ExecInterceptor {
    public static final NewRelicExecInterceptor INSTANCE = new NewRelicExecInterceptor();

    @Trace(dispatcher=true)
    public void intercept(Execution execution, ExecInterceptor.ExecType execType, Block executionSegment) throws Exception {
        execution.maybeGet(Context.class).ifPresent(context -> {
            NewRelicTransaction transaction = execution.maybeGet(NewRelicTransaction.class).orElse(null);
            if (transaction == null) {
                transaction = new DefaultNewRelicTransaction((Context)context);
                execution.add(NewRelicTransaction.class, (Object)transaction);
            }
            transaction.init();
        });
        executionSegment.execute();
    }
}

