/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import ratpack.config.FileSystemBinding;
import ratpack.core.error.ClientErrorHandler;
import ratpack.core.error.ServerErrorHandler;
import ratpack.core.file.MimeTypes;
import ratpack.core.file.internal.FileRenderer;
import ratpack.core.form.internal.FormParser;
import ratpack.core.handling.Redirector;
import ratpack.core.http.Request;
import ratpack.core.http.Response;
import ratpack.core.http.client.HttpClient;
import ratpack.core.render.internal.CharSequenceRenderer;
import ratpack.core.render.internal.PromiseRenderer;
import ratpack.core.render.internal.PublisherRenderer;
import ratpack.core.render.internal.RenderableRenderer;
import ratpack.core.server.PublicAddress;
import ratpack.core.server.RatpackServer;
import ratpack.core.server.ServerConfig;
import ratpack.core.sse.client.ServerSentEventClient;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.Execution;
import ratpack.exec.api.Blocks;
import ratpack.exec.registry.Registry;
import ratpack.guice.ExecutionScoped;
import ratpack.guice.RequestScoped;
import ratpack.guice.internal.BlockingInterceptor;
import ratpack.guice.internal.ExecutionScope;
import ratpack.guice.internal.GuiceUtil;
import ratpack.guice.internal.RequestScope;

public class RatpackBaseRegistryModule
extends AbstractModule {
    private static final List<Class<?>> SIMPLE_TYPES = ImmutableList.of(ServerConfig.class, ByteBufAllocator.class, ExecController.class, MimeTypes.class, PublicAddress.class, Redirector.class, ClientErrorHandler.class, ServerErrorHandler.class, RatpackServer.class, HttpClient.class, ServerSentEventClient.class);
    private static final ImmutableList<TypeToken<?>> PARAMETERISED_TYPES = ImmutableList.of((Object)FileRenderer.TYPE, (Object)PromiseRenderer.TYPE, (Object)PublisherRenderer.TYPE, (Object)RenderableRenderer.TYPE, (Object)CharSequenceRenderer.TYPE, (Object)FormParser.TYPE);
    private static final ImmutableList<Class<?>> OPTIONAL_TYPES = ImmutableList.of(FileSystemBinding.class);
    private final Registry baseRegistry;

    public RatpackBaseRegistryModule(Registry baseRegistry) {
        this.baseRegistry = baseRegistry;
    }

    protected void configure() {
        ExecutionScope executionScope = new ExecutionScope();
        this.bindScope(ExecutionScoped.class, executionScope);
        RequestScope requestScope = new RequestScope();
        this.bindScope(RequestScoped.class, requestScope);
        this.bind(ExecutionScope.class).toInstance((Object)executionScope);
        this.bind(RequestScope.class).toInstance((Object)requestScope);
        this.bind(ExecutionPrimingInitializer.class);
        SIMPLE_TYPES.forEach(this::simpleBind);
        PARAMETERISED_TYPES.forEach(this::parameterisedBind);
        OPTIONAL_TYPES.forEach(this::optionalBind);
        BlockingInterceptor interceptor = new BlockingInterceptor();
        this.bindInterceptor(Matchers.annotatedWith(Blocks.class), (Matcher)new NotGroovyMethodMatcher(), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Blocks.class), new MethodInterceptor[]{interceptor});
    }

    private <T> void simpleBind(Class<T> type) {
        this.bind(type).toProvider(() -> this.baseRegistry.get(type));
    }

    private <T> void parameterisedBind(TypeToken<T> typeToken) {
        this.bind(GuiceUtil.toTypeLiteral(typeToken)).toProvider(() -> this.baseRegistry.get(typeToken));
    }

    private <T> void optionalBind(Class<T> type) {
        Optional optional = this.baseRegistry.maybeGet(type);
        if (optional.isPresent()) {
            this.bind(type).toProvider(() -> this.baseRegistry.get(type));
        }
    }

    @Provides
    @ExecutionScoped
    Execution execution() {
        return Execution.current();
    }

    @Provides
    @RequestScoped
    Request request(Execution execution) throws Throwable {
        return (Request)execution.maybeGet(Request.class).orElseThrow(() -> {
            throw new RuntimeException("Cannot inject Request in execution scope as execution has no request object - this execution is not processing a request");
        });
    }

    @Provides
    @RequestScoped
    Response response(Execution execution) throws Throwable {
        return (Response)execution.maybeGet(Response.class).orElseThrow(() -> {
            throw new RuntimeException("Cannot inject Response in execution scope as execution has no response object - this execution is not processing a request");
        });
    }

    private static class NotGroovyMethodMatcher
    extends AbstractMatcher<Method> {
        private NotGroovyMethodMatcher() {
        }

        public boolean matches(Method method) {
            return !method.isSynthetic();
        }
    }

    @Singleton
    static class ExecutionPrimingInitializer
    implements ExecInitializer {
        private final List<Key<?>> executionScope;
        private final List<Key<?>> requestScope;
        private final Injector injector;

        @Inject
        public ExecutionPrimingInitializer(ExecutionScope executionScope, RequestScope requestScope, Injector injector) {
            this.executionScope = ImmutableList.copyOf((Iterable)Iterables.filter(executionScope.getKeys(), input -> !input.getTypeLiteral().getRawType().equals(Execution.class)));
            this.requestScope = ImmutableList.copyOf((Iterable)Iterables.filter(requestScope.getKeys(), input -> !input.getTypeLiteral().getRawType().equals(Request.class) && !input.getTypeLiteral().getRawType().equals(Response.class)));
            this.injector = injector;
        }

        public void init(Execution execution) {
            for (Key<?> key : this.executionScope) {
                this.doAdd(execution, key);
            }
            for (Key<?> key : this.requestScope) {
                this.doAdd(execution, key);
            }
        }

        public <T> void doAdd(Execution execution, Key<T> key) {
            execution.addLazy(GuiceUtil.toTypeToken(key.getTypeLiteral()), () -> ((Provider)this.injector.getProvider(key)).get());
        }
    }
}

