/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.reflect.TypeToken;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Optional;
import ratpack.exec.registry.RegistryBacking;
import ratpack.exec.registry.internal.CachingBackedRegistry;
import ratpack.guice.internal.InjectorRegistryBacking;

public class JustInTimeInjectorRegistry
extends CachingBackedRegistry {
    private final Injector injector;

    public JustInTimeInjectorRegistry(Injector injector) {
        super((RegistryBacking)new InjectorRegistryBacking(injector));
        this.injector = injector;
    }

    public <T> Optional<T> maybeGet(TypeToken<T> type) {
        TypeLiteral typeLiteral = TypeLiteral.get((Type)type.getType());
        try {
            return Optional.of(this.injector.getInstance(Key.get((TypeLiteral)typeLiteral)));
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }
}

