/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Constructor;
import javax.inject.Singleton;
import ratpack.config.ConfigObject;
import ratpack.core.server.ServerConfig;
import ratpack.func.Action;
import ratpack.func.Exceptions;
import ratpack.func.Factory;
import ratpack.func.Types;

public abstract class ConfigurableModule<T>
extends AbstractModule {
    private Action<? super T> configurer = Action.noop();
    private T config;

    public void configure(Action<? super T> configurer) {
        this.configurer = configurer;
    }

    protected T createConfig(ServerConfig serverConfig) {
        TypeToken typeToken = new TypeToken<T>(((Object)((Object)this)).getClass()){};
        Optional configObjectOptional = Iterables.tryFind((Iterable)serverConfig.getRequiredConfig(), arg_0 -> ConfigurableModule.lambda$createConfig$0((TypeToken)typeToken, arg_0));
        if (configObjectOptional.isPresent()) {
            return (T)Types.cast((Object)((ConfigObject)configObjectOptional.get()).getObject());
        }
        if (typeToken.getType() instanceof Class) {
            Factory factory;
            Class clazz = typeToken.getRawType();
            try {
                Constructor constructor = clazz.getConstructor(ServerConfig.class);
                factory = () -> Invokable.from((Constructor)constructor).invoke(null, new Object[]{serverConfig});
            }
            catch (NoSuchMethodException ignore) {
                try {
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    factory = () -> Invokable.from((Constructor)constructor).invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No suitable constructor (no arg, or just ServerConfig) for module config type " + typeToken);
                }
            }
            return (T)Exceptions.uncheck((Factory)factory);
        }
        throw new IllegalStateException("Can't auto instantiate configuration type " + typeToken + " as it is not a simple class");
    }

    protected void defaultConfig(ServerConfig serverConfig, T config) {
    }

    @Provides
    @Singleton
    T provideConfig(ServerConfig serverConfig) {
        T config = this.config == null ? this.createConfig(serverConfig) : this.config;
        this.defaultConfig(serverConfig, config);
        try {
            this.configurer.execute(config);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        return config;
    }

    public void setConfig(T config) {
        this.config = config;
    }

    private static /* synthetic */ boolean lambda$createConfig$0(TypeToken typeToken, ConfigObject c) {
        return c.getTypeToken().equals((Object)typeToken);
    }
}

