/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ratpack.config.ConfigObject;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.guice.BindingsImposition;
import ratpack.guice.BindingsSpec;
import ratpack.guice.internal.DefaultBindingsSpec;
import ratpack.guice.internal.GuiceUtil;
import ratpack.guice.internal.InjectorRegistryBacking;
import ratpack.guice.internal.RatpackBaseRegistryModule;
import ratpack.impose.Impositions;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;

public abstract class Guice {
    private Guice() {
    }

    public static Registry registry(Injector injector) {
        return Registry.backedBy((RegistryBacking)new InjectorRegistryBacking(injector));
    }

    public static Function<Registry, Registry> registry(Action<? super BindingsSpec> bindings) {
        return baseRegistry -> Guice.registry(bindings, baseRegistry, Guice.newInjectorFactory((ServerConfig)baseRegistry.get(ServerConfig.class)));
    }

    public static Function<Registry, Registry> registry(Injector parentInjector, Action<? super BindingsSpec> bindings) {
        return baseRegistry -> Guice.registry(bindings, baseRegistry, Guice.childInjectorFactory(parentInjector));
    }

    private static Registry registry(Action<? super BindingsSpec> bindings, Registry baseRegistry, Function<Module, Injector> injectorFactory) throws Exception {
        Injector injector = Guice.buildInjector(baseRegistry, bindings, injectorFactory);
        return Guice.registry(injector);
    }

    public static Function<Module, Injector> newInjectorFactory(ServerConfig serverConfig) {
        Stage stage = serverConfig.isDevelopment() ? Stage.DEVELOPMENT : Stage.PRODUCTION;
        return from -> from == null ? com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[0]) : com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[]{from});
    }

    private static Function<Module, Injector> childInjectorFactory(Injector parent) {
        return from -> from == null ? parent.createChildInjector(new Module[0]) : parent.createChildInjector(new Module[]{from});
    }

    static Injector buildInjector(Registry baseRegistry, Action<? super BindingsSpec> bindingsAction, Function<? super Module, ? extends Injector> injectorFactory) throws Exception {
        LinkedList binderActions = Lists.newLinkedList();
        LinkedList modules = Lists.newLinkedList();
        ServerConfig serverConfig = (ServerConfig)baseRegistry.get(ServerConfig.class);
        DefaultBindingsSpec bindings = new DefaultBindingsSpec(serverConfig, binderActions, modules);
        modules.add(new RatpackBaseRegistryModule(baseRegistry));
        modules.add(new ConfigModule((Iterable<ConfigObject<?>>)serverConfig.getRequiredConfig()));
        try {
            bindingsAction.execute((Object)bindings);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        modules.add(new AdHocModule(binderActions));
        Iterable bindingsImpositions = baseRegistry.maybeGet(Impositions.class).map(i -> i.getAll(BindingsImposition.class)).orElseGet(Collections::emptyList);
        for (BindingsImposition imposition : bindingsImpositions) {
            LinkedList imposedBinderActions = Lists.newLinkedList();
            LinkedList imposedModules = Lists.newLinkedList();
            DefaultBindingsSpec imposedBindings = new DefaultBindingsSpec(serverConfig, imposedBinderActions, imposedModules);
            imposition.getBindings().execute((Object)imposedBindings);
            imposedModules.add(new AdHocModule(imposedBinderActions));
            Module imposedModule = (Module)imposedModules.stream().reduce((acc, next) -> Modules.override((Module[])new Module[]{acc}).with(new Module[]{next})).get();
            modules.add(imposedModule);
        }
        Module masterModule = (Module)modules.stream().reduce((acc, next) -> Modules.override((Module[])new Module[]{acc}).with(new Module[]{next})).get();
        return (Injector)injectorFactory.apply((Object)masterModule);
    }

    private static class ConfigModule
    implements Module {
        private final Iterable<ConfigObject<?>> config;

        public ConfigModule(Iterable<ConfigObject<?>> config) {
            this.config = config;
        }

        public void configure(Binder binder) {
            for (ConfigObject<?> configObject : this.config) {
                ConfigModule.bind(binder, configObject);
            }
        }

        private static <T> void bind(Binder binder, ConfigObject<T> configObject) {
            binder.bind(GuiceUtil.toTypeLiteral(configObject.getTypeToken())).toInstance(configObject.getObject());
        }
    }

    private static class AdHocModule
    implements Module {
        private final List<Action<? super Binder>> binderActions;

        public AdHocModule(List<Action<? super Binder>> binderActions) {
            this.binderActions = binderActions;
        }

        public void configure(Binder binder) {
            for (Action<? super Binder> binderAction : this.binderActions) {
                binderAction.toConsumer().accept(binder);
            }
        }
    }
}

