/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Map;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.util.Exceptions;
import ratpack.util.Types;

public abstract class GuiceUtil {
    private GuiceUtil() {
    }

    public static <T> void search(Injector injector, TypeToken<T> type, Function<Provider<? extends T>, Boolean> transformer) {
        Map bindings = injector.getBindings();
        for (Map.Entry keyBindingEntry : bindings.entrySet()) {
            Key key = (Key)keyBindingEntry.getKey();
            Binding binding = (Binding)keyBindingEntry.getValue();
            TypeLiteral bindingType = key.getTypeLiteral();
            if (!type.isAssignableFrom(GuiceUtil.toTypeToken(bindingType))) continue;
            Provider provider = binding.getProvider();
            try {
                if (((Boolean)transformer.apply((Object)provider)).booleanValue()) continue;
                return;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
        Injector parent = injector.getParent();
        if (parent != null) {
            GuiceUtil.search(parent, type, transformer);
        }
    }

    public static <T> void eachOfType(Injector injector, TypeToken<T> type, Action<? super T> action) {
        GuiceUtil.search(injector, type, from -> {
            action.execute(from.get());
            return true;
        });
    }

    public static <T> void eachProviderOfType(Injector injector, TypeToken<T> type, Action<? super Provider<? extends T>> action) {
        GuiceUtil.search(injector, type, from -> {
            action.execute(from);
            return true;
        });
    }

    public static <T> ImmutableList<Provider<? extends T>> allProvidersOfType(Injector injector, TypeToken<T> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        GuiceUtil.eachProviderOfType(injector, type, arg_0 -> ((ImmutableList.Builder)listBuilder).add(arg_0));
        return listBuilder.build();
    }

    public static <T> TypeToken<T> toTypeToken(TypeLiteral<T> type) {
        return (TypeToken)Types.cast((Object)TypeToken.of((Type)type.getType()));
    }

    public static <T> TypeLiteral<T> toTypeLiteral(TypeToken<T> type) {
        return (TypeLiteral)Types.cast((Object)TypeLiteral.get((Type)type.getType()));
    }
}

