/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.reflect.TypeToken;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import ratpack.guice.internal.InjectorBackedRegistry;

public class JustInTimeInjectorRegistry
extends InjectorBackedRegistry {
    private final Injector injector;

    public JustInTimeInjectorRegistry(Injector injector) {
        super(injector);
        this.injector = injector;
    }

    @Override
    public <T> T maybeGet(Class<T> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    @Override
    public <T> T maybeGet(TypeToken<T> type) {
        TypeLiteral typeLiteral = TypeLiteral.get((Type)type.getType());
        try {
            return (T)this.injector.getInstance(Key.get((TypeLiteral)typeLiteral));
        }
        catch (ConfigurationException e) {
            return null;
        }
    }
}

