/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import ratpack.func.Action;
import ratpack.guice.internal.GuiceUtil;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.PredicateCacheability;
import ratpack.registry.Registry;
import ratpack.util.ExceptionUtils;

public class InjectorBackedRegistry
implements Registry {
    final Injector injector;
    private final LoadingCache<TypeToken<?>, List<Provider<?>>> providerCache = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, List<Provider<?>>>(){

        public List<Provider<?>> load(TypeToken<?> key) throws Exception {
            ImmutableList<Provider<?>> providers = GuiceUtil.allProvidersOfType(InjectorBackedRegistry.this.injector, key);
            return providers;
        }
    });
    private final LoadingCache<PredicateCacheability.CacheKey<?>, List<Provider<?>>> predicateCache = CacheBuilder.newBuilder().build(new CacheLoader<PredicateCacheability.CacheKey<?>, List<Provider<?>>>(){

        public List<Provider<?>> load(PredicateCacheability.CacheKey<?> key) throws Exception {
            return this.get(key);
        }

        private <T> List<Provider<?>> get(PredicateCacheability.CacheKey<T> key) throws ExecutionException {
            List providers = InjectorBackedRegistry.this.getProviders(key.type);
            if (providers.isEmpty()) {
                return Collections.emptyList();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            Predicate predicate = key.predicate;
            for (Provider provider : providers) {
                Provider castProvider = provider;
                if (!predicate.apply(castProvider.get())) continue;
                builder.add((Object)castProvider);
            }
            return builder.build();
        }
    });

    public InjectorBackedRegistry(Injector injector) {
        this.injector = injector;
    }

    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    public <T> T maybeGet(Class<T> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    public <T> T maybeGet(TypeToken<T> type) {
        List<Provider<?>> providers = this.getProviders(type);
        if (providers.isEmpty()) {
            return null;
        }
        Object cast = providers.get(0).get();
        return (T)cast;
    }

    private <T> List<Provider<?>> getProviders(TypeToken<T> type) {
        try {
            return (List)this.providerCache.get(type);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck((Throwable)ExceptionUtils.toException((Throwable)e.getCause()));
        }
    }

    public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        List<Provider<?>> providers = this.getProviders(type);
        if (providers.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.transform(providers, (Function)new Function<Provider<?>, O>(){

            public O apply(Provider<?> input) {
                Object cast = input.get();
                return cast;
            }
        });
    }

    private <T> List<Provider<?>> getAll(TypeToken<T> type, Predicate<? super T> predicate) {
        try {
            return (List)this.predicateCache.get((Object)new PredicateCacheability.CacheKey(type, predicate));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck((Throwable)ExceptionUtils.toException((Throwable)e.getCause()));
        }
    }

    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            List<Provider<?>> all = this.getAll(type, predicate);
            if (all.isEmpty()) {
                return null;
            }
            Object cast = all.get(0).get();
            return (T)cast;
        }
        T object = this.maybeGet(type);
        if (object != null && predicate.apply(object)) {
            return object;
        }
        return null;
    }

    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            List<Provider<?>> cast = this.getAll(type, predicate);
            return cast;
        }
        return Iterables.filter(this.getAll(type), predicate);
    }

    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        if (PredicateCacheability.isCacheable(predicate)) {
            Iterable<T> all = this.all(type, predicate);
            boolean any = false;
            for (T t : all) {
                any = true;
                action.execute(t);
            }
            return any;
        }
        boolean foundMatch = false;
        List<Provider<?>> providers = this.getProviders(type);
        for (Provider<?> provider : providers) {
            Object cast = provider.get();
            if (!predicate.apply(cast)) continue;
            action.execute(cast);
            foundMatch = true;
        }
        return foundMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectorBackedRegistry that = (InjectorBackedRegistry)o;
        return this.injector.equals(that.injector);
    }

    public int hashCode() {
        return this.injector.hashCode();
    }
}

