/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Provider;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.guice.BindingsSpec;
import ratpack.guice.GuiceBackedHandlerFactory;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.guice.internal.DefaultRatpackModule;
import ratpack.guice.internal.InjectorBindingHandler;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.FactoryHandler;
import ratpack.launch.LaunchConfig;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;
import ratpack.util.ExceptionUtils;

public class DefaultGuiceBackedHandlerFactory
implements GuiceBackedHandlerFactory {
    private final LaunchConfig launchConfig;

    public DefaultGuiceBackedHandlerFactory(LaunchConfig launchConfig) {
        this.launchConfig = launchConfig;
    }

    @Override
    public Handler create(final Action<? super BindingsSpec> modulesAction, final Function<? super Module, ? extends Injector> moduleTransformer, final Function<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        File classFile;
        if (this.launchConfig.isReloadable() && (classFile = ClassUtil.getClassFile(modulesAction)) != null) {
            ReloadableFileBackedFactory factory = new ReloadableFileBackedFactory(classFile.toPath(), true, (ReloadableFileBackedFactory.Producer)new ReloadableFileBackedFactory.Producer<InjectorBindingHandler>(){

                public InjectorBindingHandler produce(Path file, ByteBuf bytes) throws Exception {
                    return DefaultGuiceBackedHandlerFactory.this.doCreate((Action<? super BindingsSpec>)modulesAction, (Function<? super Module, ? extends Injector>)moduleTransformer, (Function<? super Injector, ? extends Handler>)injectorTransformer);
                }
            });
            return new FactoryHandler((Factory)factory);
        }
        return this.doCreate(modulesAction, moduleTransformer, injectorTransformer);
    }

    private InjectorBindingHandler doCreate(Action<? super BindingsSpec> modulesAction, Function<? super Module, ? extends Injector> moduleTransformer, Function<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        DefaultBindingsSpec moduleRegistry = new DefaultBindingsSpec(this.launchConfig);
        this.registerDefaultModules(moduleRegistry);
        try {
            modulesAction.execute((Object)moduleRegistry);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
        Module masterModule = null;
        List modules = moduleRegistry.getModules();
        for (Module module : modules) {
            if (masterModule == null) {
                masterModule = module;
                continue;
            }
            masterModule = Modules.override((Module[])new Module[]{masterModule}).with(new Module[]{module});
        }
        Injector injector = (Injector)moduleTransformer.apply(masterModule);
        LinkedList init = moduleRegistry.init;
        for (Action initAction : init) {
            initAction.execute((Object)injector);
        }
        Handler decorated = (Handler)injectorTransformer.apply((Object)injector);
        ArrayList modulesReversed = new ArrayList(modules);
        Collections.reverse(modulesReversed);
        for (Module module : modulesReversed) {
            if (!(module instanceof HandlerDecoratingModule)) continue;
            decorated = ((HandlerDecoratingModule)module).decorate(injector, decorated);
        }
        decorated = Handlers.chain((Handler[])new Handler[]{this.decorateHandler(decorated), Handlers.notFound()});
        return new InjectorBindingHandler(injector, decorated);
    }

    protected Handler decorateHandler(Handler handler) {
        return handler;
    }

    protected void registerDefaultModules(BindingsSpec bindingsSpec) {
        bindingsSpec.add(new Module[]{new DefaultRatpackModule(this.launchConfig)});
    }

    private static class DefaultBindingsSpec
    implements BindingsSpec {
        private final List<Module> modules = new LinkedList<Module>();
        private final LaunchConfig launchConfig;
        private final LinkedList<Action<Binder>> actions = new LinkedList();
        private final LinkedList<Action<Injector>> init = new LinkedList();

        public DefaultBindingsSpec(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
        }

        @Override
        public LaunchConfig getLaunchConfig() {
            return this.launchConfig;
        }

        @Override
        public void bind(final Class<?> type) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) throws Exception {
                    binder.bind(type);
                }
            });
        }

        @Override
        public <T> void bind(final Class<T> publicType, final Class<? extends T> implType) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) throws Exception {
                    binder.bind(publicType).to(implType);
                }
            });
        }

        @Override
        public <T> void bind(final Class<? super T> publicType, final T instance) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) throws Exception {
                    binder.bind(publicType).toInstance(instance);
                }
            });
        }

        @Override
        public <T> void bind(final T instance) {
            final Class<?> type = instance.getClass();
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) throws Exception {
                    binder.bind(type).toInstance(instance);
                }
            });
        }

        @Override
        public <T> void provider(final Class<T> publicType, final Class<? extends Provider<? extends T>> providerType) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) throws Exception {
                    binder.bind(publicType).toProvider(providerType);
                }
            });
        }

        @Override
        public void add(Module ... modules) {
            Collections.addAll(this.modules, modules);
        }

        @Override
        public void add(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        @Override
        public <T extends Module> T config(Class<T> moduleClass) {
            for (Module module : this.modules) {
                if (!moduleClass.isInstance(module)) continue;
                return (T)((Module)moduleClass.cast(module));
            }
            return null;
        }

        private List<Module> getModules() {
            return ImmutableList.builder().addAll(this.modules).add((Object)this.createOverrideModule()).build();
        }

        private Module createOverrideModule() {
            return new Module(){

                public void configure(Binder binder) {
                    for (Action binderAction : DefaultBindingsSpec.this.actions) {
                        try {
                            binderAction.execute((Object)binder);
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.uncheck((Throwable)e);
                        }
                    }
                }
            };
        }

        @Override
        public void init(Action<Injector> action) {
            this.init.add(action);
        }

        @Override
        public void init(final Class<? extends Runnable> clazz) {
            this.init.add(new Action<Injector>(){

                public void execute(Injector injector) throws Exception {
                    ((Runnable)injector.getInstance(clazz)).run();
                }
            });
        }
    }
}

