/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.guice.BindingsSpec;
import ratpack.guice.internal.DefaultGuiceBackedHandlerFactory;
import ratpack.guice.internal.InjectorBackedRegistry;
import ratpack.guice.internal.JustInTimeInjectorRegistry;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;

public abstract class Guice {
    private Guice() {
    }

    public static Handler handler(LaunchConfig launchConfig, Action<? super BindingsSpec> moduleConfigurer, Action<? super Chain> chainConfigurer) throws Exception {
        return new DefaultGuiceBackedHandlerFactory(launchConfig).create(moduleConfigurer, Guice.newInjectorFactory(launchConfig), new InjectorHandlerTransformer(launchConfig, chainConfigurer));
    }

    public static Handler handler(LaunchConfig launchConfig, Action<? super BindingsSpec> moduleConfigurer, Function<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        return new DefaultGuiceBackedHandlerFactory(launchConfig).create(moduleConfigurer, Guice.newInjectorFactory(launchConfig), injectorTransformer);
    }

    public static Handler handler(LaunchConfig launchConfig, Injector parentInjector, Action<? super BindingsSpec> moduleConfigurer, Action<? super Chain> chainConfigurer) throws Exception {
        return new DefaultGuiceBackedHandlerFactory(launchConfig).create(moduleConfigurer, Guice.childInjectorFactory(parentInjector), new InjectorHandlerTransformer(launchConfig, chainConfigurer));
    }

    public static Handler handler(LaunchConfig launchConfig, Injector parentInjector, Action<? super BindingsSpec> moduleConfigurer, Function<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        return new DefaultGuiceBackedHandlerFactory(launchConfig).create(moduleConfigurer, Guice.childInjectorFactory(parentInjector), injectorTransformer);
    }

    public static Registry justInTimeRegistry(Injector injector) {
        return new JustInTimeInjectorRegistry(injector);
    }

    public static Registry registry(Injector injector) {
        return new InjectorBackedRegistry(injector);
    }

    public static Function<Module, Injector> newInjectorFactory(LaunchConfig launchConfig) {
        final Stage stage = launchConfig.isReloadable() ? Stage.DEVELOPMENT : Stage.PRODUCTION;
        return new Function<Module, Injector>(){

            public Injector apply(Module from) {
                return from == null ? com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[0]) : com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[]{from});
            }
        };
    }

    public static Function<Module, Injector> childInjectorFactory(final Injector parent) {
        return new Function<Module, Injector>(){

            public Injector apply(Module from) {
                return from == null ? parent.createChildInjector(new Module[0]) : parent.createChildInjector(new Module[]{from});
            }
        };
    }

    private static class InjectorHandlerTransformer
    implements Function<Injector, Handler> {
        private final LaunchConfig launchConfig;
        private final Action<? super Chain> action;

        public InjectorHandlerTransformer(LaunchConfig launchConfig, Action<? super Chain> action) {
            this.launchConfig = launchConfig;
            this.action = action;
        }

        public Handler apply(Injector injector) throws Exception {
            return Handlers.chain((LaunchConfig)this.launchConfig, (Registry)Guice.justInTimeRegistry(injector), this.action);
        }
    }
}

