/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.inject.Injector;
import com.google.inject.Module;
import javax.inject.Provider;
import ratpack.func.Action;
import ratpack.guice.BindingsSpec;
import ratpack.guice.NoSuchModuleException;
import ratpack.launch.LaunchConfig;

public abstract class BindingsSpecAction
implements Action<BindingsSpec>,
BindingsSpec {
    private BindingsSpec bindingsSpec;

    protected BindingsSpec getBindingsSpec() throws IllegalStateException {
        if (this.bindingsSpec == null) {
            throw new IllegalStateException("no bindingsSpec set - BindingSpec methods should only be called during execute()");
        }
        return this.bindingsSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(BindingsSpec bindingsSpec) throws Exception {
        try {
            this.bindingsSpec = bindingsSpec;
            this.execute();
        }
        finally {
            this.bindingsSpec = bindingsSpec;
        }
    }

    protected abstract void execute() throws Exception;

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.getBindingsSpec().getLaunchConfig();
    }

    @Override
    public void add(Module ... modules) {
        this.getBindingsSpec().add(modules);
    }

    @Override
    public void add(Iterable<? extends Module> modules) {
        this.getBindingsSpec().add(modules);
    }

    @Override
    public <T extends Module> T config(Class<T> moduleClass) throws NoSuchModuleException {
        return this.getBindingsSpec().config(moduleClass);
    }

    @Override
    public void bind(Class<?> type) {
        this.getBindingsSpec().bind(type);
    }

    @Override
    public <T> void bind(Class<T> publicType, Class<? extends T> implType) {
        this.getBindingsSpec().bind(publicType, implType);
    }

    @Override
    public <T> void bind(Class<? super T> publicType, T instance) {
        this.getBindingsSpec().bind(publicType, instance);
    }

    @Override
    public <T> void bind(T instance) {
        this.getBindingsSpec().bind(instance);
    }

    @Override
    public <T> void provider(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        this.getBindingsSpec().provider(publicType, providerType);
    }

    @Override
    public void init(Action<Injector> action) {
        this.getBindingsSpec().init(action);
    }

    @Override
    public void init(Class<? extends Runnable> clazz) {
        this.getBindingsSpec().init(clazz);
    }
}

