/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import java.util.List;
import ratpack.guice.internal.GuiceUtil;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;

public class JustInTimeInjectorRegistry
implements Registry {
    private final Injector injector;

    public JustInTimeInjectorRegistry(Injector injector) {
        this.injector = injector;
    }

    public <T> T maybeGet(Class<T> type) {
        try {
            return (T)this.injector.getInstance(type);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    public <O> List<O> getAll(Class<O> type) {
        return GuiceUtil.ofType(this.injector, type);
    }

    public <O> O get(Class<O> type) throws NotInRegistryException {
        try {
            return (O)this.injector.getInstance(type);
        }
        catch (ConfigurationException e) {
            throw new NotInRegistryException(type);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JustInTimeInjectorRegistry that = (JustInTimeInjectorRegistry)o;
        return this.injector.equals(that.injector);
    }

    public int hashCode() {
        return this.injector.hashCode();
    }
}

